/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.ai.animation;

import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationAttackAI;
import com.bobmowzie.mowziesmobs.server.entity.MowzieEntity;
import com.ilexiconn.llibrary.server.animation.Animation;
import com.ilexiconn.llibrary.server.animation.IAnimatedEntity;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;

public class AnimationAreaAttackAI<T extends MowzieEntity>
extends AnimationAttackAI<T> {
    private final float arc;
    private final float height;
    private final boolean faceTarget;

    public AnimationAreaAttackAI(T entity, Animation animation, SoundEvent attackSound, SoundEvent hitSound, float applyKnockback, float range, float height, float arc, float damageMultiplier, int damageFrame) {
        this(entity, animation, attackSound, hitSound, applyKnockback, range, height, arc, damageMultiplier, damageFrame, true);
    }

    public AnimationAreaAttackAI(T entity, Animation animation, SoundEvent attackSound, SoundEvent hitSound, float applyKnockback, float range, float height, float arc, float damageMultiplier, int damageFrame, boolean faceTarget) {
        super(entity, animation, attackSound, hitSound, applyKnockback, range, damageMultiplier, damageFrame);
        this.arc = arc;
        this.height = height;
        this.faceTarget = faceTarget;
        if (faceTarget) {
            this.setFlags(EnumSet.of(Goal.Flag.LOOK));
        }
    }

    @Override
    public void start() {
        super.start();
    }

    @Override
    public void tick() {
        if (this.faceTarget && ((IAnimatedEntity)((Object)this.entity)).getAnimationTick() < this.damageFrame && this.entityTarget != null) {
            this.entity.lookAt((Entity)this.entityTarget, 30.0f, 30.0f);
        } else if (((IAnimatedEntity)((Object)this.entity)).getAnimationTick() == this.damageFrame) {
            this.hitEntities();
        }
    }

    public void hitEntities() {
        List<LivingEntity> entitiesHit = this.entity.getEntityLivingBaseNearby(this.range, this.height, this.range, this.range);
        boolean hit = false;
        for (LivingEntity entityHit : entitiesHit) {
            float entityHitAngle = (float)((Math.atan2(entityHit.getZ() - this.entity.getZ(), entityHit.getX() - this.entity.getX()) * 57.29577951308232 - 90.0) % 360.0);
            float entityAttackingAngle = this.entity.yBodyRot % 360.0f;
            if (entityHitAngle < 0.0f) {
                entityHitAngle += 360.0f;
            }
            if (entityAttackingAngle < 0.0f) {
                entityAttackingAngle += 360.0f;
            }
            float entityRelativeAngle = entityHitAngle - entityAttackingAngle;
            float entityHitDistance = (float)Math.sqrt((entityHit.getZ() - this.entity.getZ()) * (entityHit.getZ() - this.entity.getZ()) + (entityHit.getX() - this.entity.getX()) * (entityHit.getX() - this.entity.getX())) - entityHit.getBbWidth() / 2.0f;
            if (!(entityHitDistance <= this.range && entityRelativeAngle <= this.arc / 2.0f && entityRelativeAngle >= -this.arc / 2.0f || entityRelativeAngle >= 360.0f - this.arc / 2.0f) && !(entityRelativeAngle <= -360.0f + this.arc / 2.0f)) continue;
            this.entity.doHurtTarget((Entity)entityHit, this.damageMultiplier, this.applyKnockbackMultiplier);
            this.onAttack(entityHit, this.damageMultiplier, this.applyKnockbackMultiplier);
            hit = true;
        }
        if (hit && this.hitSound != null) {
            this.entity.playSound(this.hitSound, 1.0f, 1.0f);
        }
        if (this.attackSound != null) {
            this.entity.playSound(this.attackSound, 1.0f, 1.0f);
        }
    }
}

