/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.ai;

import com.bobmowzie.mowziesmobs.server.ability.Ability;
import com.bobmowzie.mowziesmobs.server.ability.AbilityHandler;
import com.bobmowzie.mowziesmobs.server.ability.AbilityType;
import com.bobmowzie.mowziesmobs.server.entity.MowzieGeckoEntity;
import java.util.EnumSet;
import net.minecraft.world.entity.ai.goal.Goal;

public class UseAbilityAI<T extends MowzieGeckoEntity>
extends Goal {
    protected final T entity;
    protected AbilityType abilityType;

    public UseAbilityAI(T entity, AbilityType ability) {
        this(entity, ability, true);
    }

    public UseAbilityAI(T entity, AbilityType ability, boolean interruptsAI) {
        this.entity = entity;
        this.abilityType = ability;
        if (interruptsAI) {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }
    }

    public boolean canUse() {
        if (((MowzieGeckoEntity)this.entity).getActiveAbility() == null) {
            return false;
        }
        return ((MowzieGeckoEntity)this.entity).getActiveAbility().getAbilityType() == this.abilityType;
    }

    public void start() {
        super.start();
    }

    public void stop() {
        super.stop();
        Ability<?> ability = ((MowzieGeckoEntity)this.entity).getActiveAbility();
        if (ability != null && ability.getAbilityType() == this.abilityType) {
            AbilityHandler.INSTANCE.sendInterruptAbilityMessage(this.entity, ability.getAbilityType());
        }
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }
}

