/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.ability.abilities.player.heliomancy;

import com.bobmowzie.mowziesmobs.server.ability.AbilitySection;
import com.bobmowzie.mowziesmobs.server.ability.AbilityType;
import com.bobmowzie.mowziesmobs.server.ability.PlayerAbility;
import com.bobmowzie.mowziesmobs.server.ability.abilities.player.heliomancy.HeliomancyAbilityBase;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.entity.EntityHandler;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntitySolarBeam;
import com.bobmowzie.mowziesmobs.server.potion.EffectHandler;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import software.bernie.geckolib.animation.RawAnimation;

public class SolarBeamAbility
extends HeliomancyAbilityBase {
    protected EntitySolarBeam solarBeam;
    private static final RawAnimation SOLAR_BEAM_CHARGE_ANIM = RawAnimation.begin().thenPlay("solar_beam_charge");

    public SolarBeamAbility(AbilityType<Player, SolarBeamAbility> abilityType, Player user) {
        super(abilityType, user, new AbilitySection[]{new AbilitySection.AbilitySectionDuration(AbilitySection.AbilitySectionType.STARTUP, 20), new AbilitySection.AbilitySectionDuration(AbilitySection.AbilitySectionType.ACTIVE, 55), new AbilitySection.AbilitySectionDuration(AbilitySection.AbilitySectionType.RECOVERY, 20)});
    }

    @Override
    public void start() {
        EntitySolarBeam solarBeam;
        super.start();
        Object user = this.getUser();
        this.solarBeam = solarBeam = new EntitySolarBeam((EntityType<? extends EntitySolarBeam>)((EntityType)EntityHandler.SOLAR_BEAM.get()), user.level(), (LivingEntity)user, user.getX(), user.getY() + (double)1.2f, user.getZ(), (float)((double)(((LivingEntity)user).yHeadRot + 90.0f) * Math.PI / 180.0), (float)((double)(-user.getXRot()) * Math.PI / 180.0), 55);
        if (!((Player)this.getUser()).level().isClientSide()) {
            solarBeam.setHasPlayer(true);
            user.level().addFreshEntity((Entity)solarBeam);
            user.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 80, 2, false, false));
        } else {
            this.heldItemMainHandVisualOverride = ItemStack.EMPTY;
            this.heldItemOffHandVisualOverride = ItemStack.EMPTY;
            this.firstPersonOffHandDisplay = PlayerAbility.HandDisplay.FORCE_RENDER;
            this.firstPersonMainHandDisplay = PlayerAbility.HandDisplay.FORCE_RENDER;
        }
        this.playAnimation(SOLAR_BEAM_CHARGE_ANIM);
    }

    @Override
    protected void beginSection(AbilitySection section) {
        MobEffectInstance sunsBlessingInstance;
        super.beginSection(section);
        if (section.sectionType == AbilitySection.AbilitySectionType.ACTIVE && !this.getLevel().isClientSide() && (sunsBlessingInstance = ((Player)this.getUser()).getEffect(EffectHandler.SUNS_BLESSING)) != null) {
            int duration = sunsBlessingInstance.getDuration();
            ((Player)this.getUser()).removeEffect(EffectHandler.SUNS_BLESSING);
            int solarBeamCost = (Integer)ConfigHandler.COMMON.TOOLS_AND_ABILITIES.SUNS_BLESSING.solarBeamCost.get() * 60 * 20;
            if (duration - solarBeamCost > 0) {
                ((Player)this.getUser()).addEffect(new MobEffectInstance(EffectHandler.SUNS_BLESSING, duration - solarBeamCost, 0, false, false));
            }
        }
    }

    @Override
    public void end() {
        super.end();
        if (this.solarBeam != null) {
            this.solarBeam.discard();
        }
    }
}

