/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.ability.abilities.player.geomancy;

import com.bobmowzie.mowziesmobs.MMCommon;
import com.bobmowzie.mowziesmobs.client.particle.ParticleHandler;
import com.bobmowzie.mowziesmobs.client.particle.util.AdvancedParticleBase;
import com.bobmowzie.mowziesmobs.client.particle.util.ParticleComponent;
import com.bobmowzie.mowziesmobs.server.ability.Ability;
import com.bobmowzie.mowziesmobs.server.ability.AbilityHandler;
import com.bobmowzie.mowziesmobs.server.ability.AbilitySection;
import com.bobmowzie.mowziesmobs.server.ability.AbilityType;
import com.bobmowzie.mowziesmobs.server.ability.PlayerAbility;
import com.bobmowzie.mowziesmobs.server.entity.EntityHandler;
import com.bobmowzie.mowziesmobs.server.entity.effects.geomancy.EntityBoulderBase;
import com.bobmowzie.mowziesmobs.server.entity.effects.geomancy.EntityBoulderProjectile;
import com.bobmowzie.mowziesmobs.server.entity.effects.geomancy.EntityGeomancyBase;
import com.bobmowzie.mowziesmobs.server.item.ItemHandler;
import com.bobmowzie.mowziesmobs.server.potion.EffectGeomancy;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.event.RenderFrameEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import software.bernie.geckolib.animation.Animation;

public class SpawnBoulderAbility
extends PlayerAbility {
    private static final int MAX_CHARGE = 60;
    public static final double SPAWN_BOULDER_REACH = 5.0;
    public BlockPos spawnBoulderPos = new BlockPos(0, 0, 0);
    public Vec3 lookPos = new Vec3(0.0, 0.0, 0.0);
    private BlockState spawnBoulderBlock = Blocks.DIRT.defaultBlockState();
    private int spawnBoulderCharge = 0;
    private EntityGeomancyBase.GeomancyTier boulderSize = EntityGeomancyBase.GeomancyTier.SMALL;
    private static final AbilitySection NO_CHARGE_SECTION = new AbilitySection.AbilitySectionDuration(AbilitySection.AbilitySectionType.STARTUP, 5);
    private static final AbilitySection SMALL_CHARGE_SECTION = new AbilitySection.AbilitySectionDuration(AbilitySection.AbilitySectionType.STARTUP, 8);
    private static final AbilitySection MEDIUM_CHARGE_SECTION = new AbilitySection.AbilitySectionDuration(AbilitySection.AbilitySectionType.STARTUP, 8);
    private static final AbilitySection LARGE_CHARGE_SECTION = new AbilitySection.AbilitySectionDuration(AbilitySection.AbilitySectionType.STARTUP, 8);
    private static final AbilitySection HUGE_CHARGE_SECTION = new AbilitySection.AbilitySectionDuration(AbilitySection.AbilitySectionType.STARTUP, 20);

    public SpawnBoulderAbility(AbilityType<Player, ? extends Ability> abilityType, Player user) {
        super(abilityType, user, new AbilitySection[]{NO_CHARGE_SECTION, SMALL_CHARGE_SECTION, MEDIUM_CHARGE_SECTION, LARGE_CHARGE_SECTION, HUGE_CHARGE_SECTION, new AbilitySection.AbilitySectionInstant(AbilitySection.AbilitySectionType.ACTIVE), new AbilitySection.AbilitySectionDuration(AbilitySection.AbilitySectionType.RECOVERY, 12)});
    }

    @Override
    public InteractionHand getActiveHand() {
        if (((Player)this.getUser()).getMainHandItem().is((Item)ItemHandler.EARTHREND_GAUNTLET.get())) {
            return InteractionHand.MAIN_HAND;
        }
        if (((Player)this.getUser()).getOffhandItem().is((Item)ItemHandler.EARTHREND_GAUNTLET.get())) {
            return InteractionHand.OFF_HAND;
        }
        return InteractionHand.MAIN_HAND;
    }

    @Override
    public void start() {
        super.start();
        this.boulderSize = EntityGeomancyBase.GeomancyTier.SMALL;
        if (this.getLevel().isClientSide()) {
            this.playAnimation("spawn_boulder_start", Animation.LoopType.DEFAULT, true, false);
            if (((Player)this.getUser()).getUsedItemHand() == InteractionHand.MAIN_HAND) {
                this.heldItemMainHandVisualOverride = ((Player)this.getUser()).getUseItem();
            } else {
                this.heldItemOffHandVisualOverride = ((Player)this.getUser()).getUseItem();
            }
        }
    }

    @Override
    public boolean tryAbility() {
        Vec3 from = ((Player)this.getUser()).getEyePosition(1.0f);
        Vec3 to = from.add(((Player)this.getUser()).getLookAngle().scale(5.0));
        BlockHitResult result = ((Player)this.getUser()).level().clip(new ClipContext(from, to, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, this.getUser()));
        if (result.getType() == HitResult.Type.BLOCK) {
            this.lookPos = result.getLocation();
        }
        this.spawnBoulderPos = result.getBlockPos();
        this.spawnBoulderBlock = ((Player)this.getUser()).level().getBlockState(this.spawnBoulderPos);
        if (result.getDirection() == Direction.DOWN) {
            return false;
        }
        BlockState blockAbove = ((Player)this.getUser()).level().getBlockState(this.spawnBoulderPos.above());
        if (blockAbove.blocksMotion()) {
            return false;
        }
        return EffectGeomancy.isBlockUseable(this.spawnBoulderBlock);
    }

    @Override
    public void tickUsing() {
        super.tickUsing();
        if (this.getCurrentSection().sectionType == AbilitySection.AbilitySectionType.STARTUP) {
            int size;
            ++this.spawnBoulderCharge;
            if (this.spawnBoulderCharge > 2) {
                ((Player)this.getUser()).addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 3, 0, false, false));
            }
            if (this.spawnBoulderCharge == 1 && ((Player)this.getUser()).level().isClientSide) {
                MMCommon.PROXY.playBoulderChargeSound((LivingEntity)this.getUser());
            }
            if (this.spawnBoulderCharge == 45) {
                if (((Player)this.getUser()).level().isClientSide) {
                    AdvancedParticleBase.spawnParticle(((Player)this.getUser()).level(), ParticleHandler.RING2, (float)((Player)this.getUser()).getX(), (float)((Player)this.getUser()).getY() + ((Player)this.getUser()).getBbHeight() / 2.0f, (float)((Player)this.getUser()).getZ(), 0.0, 0.0, 0.0, true, 0.0, 0.0, 0.0, 0.0, 3.5, 0.83f, 1.0, 0.39f, 1.0, 1.0, 20.0, true, true, new ParticleComponent[]{new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.ALPHA, ParticleComponent.KeyTrack.startAndEnd(0.7f, 0.0f), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, ParticleComponent.KeyTrack.startAndEnd(0.0f, 40.0f), false)});
                }
                ((Player)this.getUser()).playSound((SoundEvent)MMSounds.EFFECT_GEOMANCY_MAGIC_SMALL.get(), 1.0f, 1.0f);
            }
            if ((size = this.getBoulderSize().index + 1) > 4) {
                size = 4;
            }
            EntityDimensions dim = EntityBoulderBase.SIZE_MAP.get((Object)EntityGeomancyBase.GeomancyTier.values()[size]);
            if (!((Player)this.getUser()).level().noCollision(dim.makeBoundingBox((double)((float)this.spawnBoulderPos.getX() + 0.5f), (double)(this.spawnBoulderPos.getY() + 2), (double)((float)this.spawnBoulderPos.getZ() + 0.5f))) || ((Player)this.getUser()).distanceToSqr((double)this.spawnBoulderPos.getX(), (double)this.spawnBoulderPos.getY(), (double)this.spawnBoulderPos.getZ()) > 36.0) {
                this.jumpToSection(5);
            }
        }
    }

    @Override
    protected void beginSection(AbilitySection section) {
        if (section.sectionType == AbilitySection.AbilitySectionType.STARTUP && section != NO_CHARGE_SECTION && ((Player)this.getUser()).level().isClientSide) {
            float scale = 5.0f;
            if (section == MEDIUM_CHARGE_SECTION) {
                scale = 8.0f;
            } else if (section == LARGE_CHARGE_SECTION) {
                scale = 12.0f;
            } else if (section == HUGE_CHARGE_SECTION) {
                scale = 16.0f;
            }
            AdvancedParticleBase.spawnParticle(((Player)this.getUser()).level(), ParticleHandler.RING2, (float)this.spawnBoulderPos.getX() + 0.5f, (double)this.spawnBoulderPos.getY() + 1.01, (float)this.spawnBoulderPos.getZ() + 0.5f, 0.0, 0.0, 0.0, false, 0.0, 1.5707963267948966, 0.0, 0.0, scale, 0.83f, 1.0, 0.39f, 1.0, 1.0, 10.0, true, true, new ParticleComponent[]{new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.ALPHA, ParticleComponent.KeyTrack.startAndEnd(0.7f, 0.0f), false)});
        }
        if (section == MEDIUM_CHARGE_SECTION) {
            this.boulderSize = EntityGeomancyBase.GeomancyTier.MEDIUM;
        }
        if (section == LARGE_CHARGE_SECTION) {
            this.boulderSize = EntityGeomancyBase.GeomancyTier.LARGE;
        }
        if (section == HUGE_CHARGE_SECTION) {
            this.boulderSize = EntityGeomancyBase.GeomancyTier.HUGE;
        }
        if (section.sectionType == AbilitySection.AbilitySectionType.ACTIVE) {
            this.spawnBoulder();
        }
    }

    private EntityGeomancyBase.GeomancyTier getBoulderSize() {
        return this.boulderSize;
    }

    private void spawnBoulder() {
        if (this.spawnBoulderCharge <= 2) {
            this.playAnimation("spawn_boulder_instant", Animation.LoopType.DEFAULT, true, false);
        } else {
            this.playAnimation("spawn_boulder_end", Animation.LoopType.DEFAULT, true, false);
        }
        EntityBoulderProjectile boulder = new EntityBoulderProjectile((EntityType<? extends EntityBoulderProjectile>)((EntityType)EntityHandler.BOULDER_PROJECTILE.get()), ((Player)this.getUser()).level(), (LivingEntity)this.getUser(), this.spawnBoulderBlock, this.spawnBoulderPos, this.getBoulderSize());
        boulder.setPos((float)this.spawnBoulderPos.getX() + 0.5f, this.spawnBoulderPos.getY() + 2, (float)this.spawnBoulderPos.getZ() + 0.5f);
        if (!((Player)this.getUser()).level().isClientSide && boulder.checkCanSpawn()) {
            ((Player)this.getUser()).level().addFreshEntity((Entity)boulder);
        }
        if (this.spawnBoulderCharge > 2) {
            Vec3 playerEyes = ((Player)this.getUser()).getEyePosition(1.0f);
            Vec3 vec = playerEyes.subtract(this.lookPos).normalize();
            float yaw = (float)Math.atan2(vec.z, vec.x);
            float pitch = (float)Math.asin(vec.y);
            ((Player)this.getUser()).setYRot((float)((double)(yaw * 180.0f) / Math.PI + 90.0));
            ((Player)this.getUser()).setXRot((float)((double)(pitch * 180.0f) / Math.PI));
        }
        this.spawnBoulderCharge = 0;
    }

    @Override
    public void onRightMouseUp(Player player) {
        super.onRightMouseUp(player);
        if (this.isUsing() && this.getCurrentSection().sectionType == AbilitySection.AbilitySectionType.STARTUP && this.getCurrentSection() != HUGE_CHARGE_SECTION) {
            if (player.distanceToSqr((double)this.spawnBoulderPos.getX(), (double)this.spawnBoulderPos.getY(), (double)this.spawnBoulderPos.getZ()) < 36.0) {
                this.jumpToSection(5);
            } else {
                this.spawnBoulderCharge = 0;
            }
        }
    }

    @Override
    public boolean canUse() {
        return EffectGeomancy.canUse(this.getUser()) && super.canUse();
    }

    @Override
    public void end() {
        this.spawnBoulderCharge = 0;
        super.end();
    }

    @Override
    public void readNBT(Tag nbt) {
        super.readNBT(nbt);
        if (this.getCurrentSection().sectionType == AbilitySection.AbilitySectionType.STARTUP) {
            this.spawnBoulderCharge = this.getTicksInUse();
        }
    }

    @Override
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        super.onRightClickBlock(event);
        if (!event.getLevel().isClientSide()) {
            AbilityHandler.INSTANCE.sendAbilityMessage(event.getEntity(), AbilityHandler.SPAWN_BOULDER_ABILITY);
        }
    }

    @Override
    public void onRightClickEmpty(PlayerInteractEvent.RightClickEmpty event) {
        super.onRightClickEmpty(event);
        AbilityHandler.INSTANCE.sendPlayerTryAbilityMessage(event.getEntity(), AbilityHandler.SPAWN_BOULDER_ABILITY);
    }

    @Override
    public void onRenderTick(RenderFrameEvent event) {
        super.onRenderTick(event);
        if (this.isUsing() && this.getCurrentSection().sectionType == AbilitySection.AbilitySectionType.STARTUP && this.getTicksInUse() > 1) {
            Vec3 playerEyes = ((Player)this.getUser()).getEyePosition(event.getPartialTick().getGameTimeDeltaPartialTick(false));
            Vec3 vec = playerEyes.subtract(this.lookPos).normalize();
            float yaw = (float)Math.atan2(vec.z, vec.x);
            float pitch = (float)Math.asin(vec.y);
            ((Player)this.getUser()).setYRot((float)((double)(yaw * 180.0f) / Math.PI + 90.0));
            ((Player)this.getUser()).setXRot((float)((double)(pitch * 180.0f) / Math.PI));
            ((Player)this.getUser()).yHeadRot = ((Player)this.getUser()).getYRot();
            ((Player)this.getUser()).yRotO = ((Player)this.getUser()).getYRot();
            ((Player)this.getUser()).xRotO = ((Player)this.getUser()).getXRot();
            ((Player)this.getUser()).yHeadRotO = ((Player)this.getUser()).yHeadRot;
        }
    }
}

