/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.ability.abilities.player.geomancy;

import com.bobmowzie.mowziesmobs.server.ability.Ability;
import com.bobmowzie.mowziesmobs.server.ability.AbilitySection;
import com.bobmowzie.mowziesmobs.server.ability.AbilityType;
import com.bobmowzie.mowziesmobs.server.ability.PlayerAbility;
import com.bobmowzie.mowziesmobs.server.entity.EntityHandler;
import com.bobmowzie.mowziesmobs.server.entity.effects.geomancy.EntityBoulderProjectile;
import com.bobmowzie.mowziesmobs.server.entity.effects.geomancy.EntityGeomancyBase;
import com.bobmowzie.mowziesmobs.server.entity.effects.geomancy.EntityRockSling;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animation.Animation;

public class RockSlingAbility
extends PlayerAbility {
    public static final double SPAWN_BOULDER_REACH = 5.0;
    public BlockPos spawnBoulderPos = new BlockPos(0, 0, 0);
    public Vec3 lookPos = new Vec3(0.0, 0.0, 0.0);
    private BlockState spawnBoulderBlock = Blocks.DIRT.defaultBlockState();

    public RockSlingAbility(AbilityType<Player, ? extends Ability<?>> abilityType, Player user) {
        super(abilityType, user, new AbilitySection[]{new AbilitySection.AbilitySectionDuration(AbilitySection.AbilitySectionType.STARTUP, 5), new AbilitySection.AbilitySectionDuration(AbilitySection.AbilitySectionType.ACTIVE, 10), new AbilitySection.AbilitySectionDuration(AbilitySection.AbilitySectionType.RECOVERY, 5)}, 15);
    }

    @Override
    public void start() {
        super.start();
        Vec3 from = ((Player)this.getUser()).getEyePosition(1.0f);
        Vec3 to = from.add(((Player)this.getUser()).getLookAngle().scale(5.0));
        BlockHitResult result = ((Player)this.getUser()).level().clip(new ClipContext(from, to, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, this.getUser()));
        if (result.getType() == HitResult.Type.BLOCK) {
            this.lookPos = result.getLocation();
        }
        this.spawnBoulderPos = result.getBlockPos();
        this.spawnBoulderBlock = ((Player)this.getUser()).level().getBlockState(this.spawnBoulderPos);
        this.playAnimation("rock_sling", Animation.LoopType.DEFAULT, true, true);
        if (!((Player)this.getUser()).level().isClientSide()) {
            for (int i = 0; i < 3; ++i) {
                Vec3 spawnPos = new Vec3(0.0, -1.0, 2.5).yRot((float)Math.toRadians(-((Player)this.getUser()).getYRot())).yRot((float)Math.toRadians(-45 + i * 45)).add(((Player)this.getUser()).position());
                EntityRockSling boulder = new EntityRockSling((EntityType<? extends EntityBoulderProjectile>)((EntityType)EntityHandler.ROCK_SLING.get()), ((Player)this.getUser()).level(), (LivingEntity)this.getUser(), this.spawnBoulderBlock, this.spawnBoulderPos, EntityGeomancyBase.GeomancyTier.values()[1]);
                boulder.setPos(spawnPos.x() + 0.5, spawnPos.y() + 2.0, spawnPos.z() + 0.5);
                boulder.setLaunchVec(((Player)this.getUser()).getViewVector(1.0f).multiply(1.0, (double)0.9f, 1.0));
                if (((Player)this.getUser()).level().isClientSide || !boulder.checkCanSpawn()) continue;
                ((Player)this.getUser()).level().addFreshEntity((Entity)boulder);
            }
        }
    }
}

