/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.render.block;

import com.bobmowzie.mowziesmobs.client.model.LayerHandler;
import com.bobmowzie.mowziesmobs.client.model.tools.MathUtils;
import com.bobmowzie.mowziesmobs.server.block.entity.GongBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class GongRenderer
implements BlockEntityRenderer<GongBlockEntity> {
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"mowziesmobs", (String)"textures/block/gong.png");
    private final ModelPart gongBase;
    private final ModelPart chain;

    public GongRenderer(BlockEntityRendererProvider.Context context) {
        ModelPart modelpart = context.bakeLayer(LayerHandler.GONG_LAYER);
        this.gongBase = modelpart.getChild("root");
        this.chain = this.gongBase.getChild("chain");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition root = partdefinition.addOrReplaceChild("root", CubeListBuilder.create().texOffs(88, 46).addBox(-35.75f, -23.25f, 5.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(112, 16).addBox(0.25f, -57.25f, 7.0f, 4.0f, 34.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(48, 32).addBox(-1.75f, -59.25f, 5.0f, 8.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(88, 46).addBox(-1.75f, -23.25f, 5.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(112, 16).addBox(-33.75f, -57.25f, 7.0f, 4.0f, 34.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(48, 32).addBox(-35.75f, -59.25f, 5.0f, 8.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(0, 16).addBox(-37.75f, -56.25f, 7.5f, 46.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-38.75f, -63.25f, 3.0f, 48.0f, 4.0f, 12.0f, new CubeDeformation(0.0f)).texOffs(48, 21).addBox(-27.75f, -59.25f, 8.5f, 26.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)14.75f, (float)39.25f, (float)-8.5f));
        PartDefinition chain = root.addOrReplaceChild("chain", CubeListBuilder.create().texOffs(48, 24).addBox(-11.0f, 0.0f, 0.0f, 22.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-14.75f, (float)-54.25f, (float)8.5f));
        PartDefinition gong = chain.addOrReplaceChild("gong", CubeListBuilder.create().texOffs(0, 21).addBox(-11.75f, -11.75f, -1.0f, 22.0f, 22.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(108, 4).addBox(-3.75f, -3.75f, -1.0f, 6.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(48, 42).addBox(-9.75f, -9.75f, -1.0f, 18.0f, 18.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 45).addBox(-9.75f, -9.75f, -0.5f, 18.0f, 18.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.75f, (float)19.75f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void render(GongBlockEntity entity, float delta, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int overlay) {
        poseStack.pushPose();
        poseStack.translate(0.5, 1.485, 0.5);
        poseStack.mulPose(MathUtils.quatFromRotationXYZ(0.0f, 0.0f, 180.0f, true));
        if (entity.facing.getAxis() == Direction.Axis.X) {
            poseStack.mulPose(MathUtils.quatFromRotationXYZ(0.0f, 90.0f, 0.0f, true));
        }
        float f = (float)entity.ticks + delta;
        float f1 = 0.0f;
        if (entity.shaking) {
            float f3 = Mth.sin((float)(f / (float)Math.PI)) / (4.0f + f / 2.0f);
            if (entity.clickDirection == Direction.NORTH) {
                f1 = f3;
            } else if (entity.clickDirection == Direction.SOUTH) {
                f1 = -f3;
            } else if (entity.clickDirection == Direction.EAST) {
                f1 = f3;
            } else if (entity.clickDirection == Direction.WEST) {
                f1 = -f3;
            }
        }
        this.chain.xRot = f1;
        VertexConsumer vertexconsumer = buffer.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)TEXTURE));
        this.gongBase.render(poseStack, vertexconsumer, packedLight, overlay);
        poseStack.popPose();
    }

    @NotNull
    public AABB getRenderBoundingBox(@NotNull GongBlockEntity gong) {
        AABB bounds = new AABB(gong.getBlockPos());
        bounds = bounds.expandTowards(new Vec3(gong.facing.getClockWise().step()));
        bounds = bounds.expandTowards(new Vec3(gong.facing.getCounterClockWise().step()));
        bounds = bounds.expandTowards(0.0, 2.0, 0.0);
        return bounds;
    }
}

