/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.model.entity;

import com.bobmowzie.mowziesmobs.client.model.entity.ModelBipedAnimated;
import com.bobmowzie.mowziesmobs.client.model.entity.ModelGeckoPlayerThirdPerson;
import com.bobmowzie.mowziesmobs.client.model.tools.ModelPartMatrix;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;

public class ModelPlayerAnimated<T extends LivingEntity>
extends PlayerModel<T> {
    private final List<ModelPart> parts;

    public ModelPlayerAnimated(ModelPart root, boolean smallArmsIn) {
        super(root, smallArmsIn);
        ModelPartMatrix bodyMatrix = new ModelPartMatrix(this.body, false);
        ModelPartMatrix headMatrix = new ModelPartMatrix(this.head, false);
        ModelPartMatrix rightArmMatrix = new ModelPartMatrix(this.rightArm, false);
        ModelPartMatrix leftArmMatrix = new ModelPartMatrix(this.leftArm, false);
        ModelPartMatrix rightLegMatrix = new ModelPartMatrix(this.rightLeg, false);
        ModelPartMatrix leftLegMatrix = new ModelPartMatrix(this.leftLeg, false);
        ModelPartMatrix hatMatrix = new ModelPartMatrix(this.hat, false);
        ModelPartMatrix jacketMatrix = new ModelPartMatrix(this.jacket, false);
        ModelPartMatrix leftSleeveMatrix = new ModelPartMatrix(this.leftSleeve, false);
        ModelPartMatrix rightSleeveMatrix = new ModelPartMatrix(this.rightSleeve, false);
        ModelPartMatrix leftPantsMatrix = new ModelPartMatrix(this.leftPants, false);
        ModelPartMatrix rightPantsMatrix = new ModelPartMatrix(this.rightPants, false);
        ModelPartMatrix earMatrix = new ModelPartMatrix(this.ear, false);
        HashMap<ModelPart, ModelPartMatrix> origToNew = new HashMap<ModelPart, ModelPartMatrix>();
        origToNew.put(this.body, bodyMatrix);
        origToNew.put(this.head, headMatrix);
        origToNew.put(this.rightArm, rightArmMatrix);
        origToNew.put(this.leftArm, leftArmMatrix);
        origToNew.put(this.rightLeg, rightLegMatrix);
        origToNew.put(this.leftLeg, leftLegMatrix);
        origToNew.put(this.hat, hatMatrix);
        origToNew.put(this.jacket, jacketMatrix);
        origToNew.put(this.leftSleeve, leftSleeveMatrix);
        origToNew.put(this.rightSleeve, rightSleeveMatrix);
        origToNew.put(this.leftPants, leftPantsMatrix);
        origToNew.put(this.rightPants, rightPantsMatrix);
        origToNew.put(this.ear, earMatrix);
        this.body = bodyMatrix;
        this.head = headMatrix;
        this.rightArm = rightArmMatrix;
        this.leftArm = leftArmMatrix;
        this.rightLeg = rightLegMatrix;
        this.leftLeg = leftLegMatrix;
        this.hat = hatMatrix;
        this.jacket = jacketMatrix;
        this.leftSleeve = leftSleeveMatrix;
        this.rightSleeve = rightSleeveMatrix;
        this.leftPants = leftPantsMatrix;
        this.rightPants = rightPantsMatrix;
        this.ear = earMatrix;
        List originalList = (List)root.getAllParts().filter(p_170824_ -> !p_170824_.isEmpty()).collect(ImmutableList.toImmutableList());
        this.parts = new ArrayList<ModelPart>();
        for (ModelPart origPart : originalList) {
            ModelPart newPart = (ModelPart)origToNew.get(origPart);
            if (newPart == null) continue;
            this.parts.add(newPart);
        }
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.leftPants.copyFrom(this.leftLeg);
        this.rightPants.copyFrom(this.rightLeg);
        this.leftSleeve.copyFrom(this.leftArm);
        this.rightSleeve.copyFrom(this.rightArm);
        this.jacket.copyFrom(this.body);
        this.hat.copyFrom(this.head);
        this.ear.copyFrom(this.head);
    }

    public ModelPart getRandomModelPart(RandomSource randomIn) {
        return this.parts.get(randomIn.nextInt(this.parts.size()));
    }

    public void copyPropertiesTo(HumanoidModel<T> modelIn) {
        if (!(modelIn.body instanceof ModelPartMatrix)) {
            modelIn.head = new ModelPartMatrix(modelIn.head);
            modelIn.hat = new ModelPartMatrix(modelIn.hat);
            modelIn.body = new ModelPartMatrix(modelIn.body);
            modelIn.leftArm = new ModelPartMatrix(modelIn.leftArm);
            modelIn.rightArm = new ModelPartMatrix(modelIn.rightArm);
            modelIn.leftLeg = new ModelPartMatrix(modelIn.leftLeg);
            modelIn.rightLeg = new ModelPartMatrix(modelIn.rightLeg);
        }
        ModelBipedAnimated.setUseMatrixMode(modelIn, true);
        super.copyPropertiesTo(modelIn);
    }

    public static void setUseMatrixMode(PlayerModel<? extends LivingEntity> bipedModel, boolean useMatrixMode) {
        if (bipedModel.hat instanceof ModelPartMatrix) {
            ((ModelPartMatrix)bipedModel.jacket).setUseMatrixMode(useMatrixMode);
            ((ModelPartMatrix)bipedModel.leftPants).setUseMatrixMode(useMatrixMode);
            ((ModelPartMatrix)bipedModel.rightPants).setUseMatrixMode(useMatrixMode);
            ((ModelPartMatrix)bipedModel.rightSleeve).setUseMatrixMode(useMatrixMode);
            ((ModelPartMatrix)bipedModel.leftSleeve).setUseMatrixMode(useMatrixMode);
            ((ModelPartMatrix)bipedModel.ear).setUseMatrixMode(useMatrixMode);
        }
        ModelBipedAnimated.setUseMatrixMode(bipedModel, useMatrixMode);
    }

    public static void copyFromGeckoModel(PlayerModel<?> playerModel, ModelGeckoPlayerThirdPerson geckoModel) {
        ModelBipedAnimated.copyFromGeckoModel(playerModel, geckoModel);
        if (playerModel.jacket instanceof ModelPartMatrix) {
            ((ModelPartMatrix)playerModel.jacket).setWorldXform(geckoModel.bipedBody().getWorldSpaceMatrix());
            ((ModelPartMatrix)playerModel.jacket).setWorldNormal(geckoModel.bipedBody().getWorldSpaceNormal());
        }
        if (playerModel.leftPants instanceof ModelPartMatrix) {
            ((ModelPartMatrix)playerModel.leftPants).setWorldXform(geckoModel.bipedLeftLeg().getWorldSpaceMatrix());
            ((ModelPartMatrix)playerModel.leftPants).setWorldNormal(geckoModel.bipedLeftLeg().getWorldSpaceNormal());
        }
        if (playerModel.rightPants instanceof ModelPartMatrix) {
            ((ModelPartMatrix)playerModel.rightPants).setWorldXform(geckoModel.bipedRightLeg().getWorldSpaceMatrix());
            ((ModelPartMatrix)playerModel.rightPants).setWorldNormal(geckoModel.bipedRightLeg().getWorldSpaceNormal());
        }
        if (playerModel.rightSleeve instanceof ModelPartMatrix) {
            ((ModelPartMatrix)playerModel.rightSleeve).setWorldXform(geckoModel.bipedRightArm().getWorldSpaceMatrix());
            ((ModelPartMatrix)playerModel.rightSleeve).setWorldNormal(geckoModel.bipedRightArm().getWorldSpaceNormal());
        }
        if (playerModel.leftSleeve instanceof ModelPartMatrix) {
            ((ModelPartMatrix)playerModel.leftSleeve).setWorldXform(geckoModel.bipedLeftArm().getWorldSpaceMatrix());
            ((ModelPartMatrix)playerModel.leftSleeve).setWorldNormal(geckoModel.bipedLeftArm().getWorldSpaceNormal());
        }
        if (playerModel.ear instanceof ModelPartMatrix) {
            ((ModelPartMatrix)playerModel.ear).setWorldXform(geckoModel.bipedHead().getWorldSpaceMatrix());
            ((ModelPartMatrix)playerModel.ear).setWorldNormal(geckoModel.bipedHead().getWorldSpaceNormal());
        }
    }
}

