/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.gui;

import com.bobmowzie.mowziesmobs.server.entity.umvuthana.EntityUmvuthi;
import com.bobmowzie.mowziesmobs.server.inventory.ContainerUmvuthiTrade;
import com.bobmowzie.mowziesmobs.server.inventory.InventoryOneInput;
import com.bobmowzie.mowziesmobs.server.inventory.InventoryUmvuthi;
import com.bobmowzie.mowziesmobs.server.item.ItemHandler;
import com.bobmowzie.mowziesmobs.server.message.MessageUmvuthiTrade;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.network.PacketDistributor;

public final class GuiUmvuthiTrade
extends AbstractContainerScreen<ContainerUmvuthiTrade>
implements InventoryOneInput.ChangeListener {
    private static final ResourceLocation TEXTURE_TRADE = ResourceLocation.fromNamespaceAndPath((String)"mowziesmobs", (String)"textures/gui/container/umvuthi_trade.png");
    private static final ResourceLocation TEXTURE_REPLENISH = ResourceLocation.fromNamespaceAndPath((String)"mowziesmobs", (String)"textures/gui/container/umvuthi_replenish.png");
    private final EntityUmvuthi umvuthi;
    private final Player player;
    private final InventoryUmvuthi inventory;
    private final ItemStack output = new ItemStack((ItemLike)ItemHandler.GRANT_SUNS_BLESSING.get());
    private Button grantButton;
    private boolean hasTraded;

    public GuiUmvuthiTrade(ContainerUmvuthiTrade screenContainer, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenContainer, inv, titleIn);
        this.umvuthi = screenContainer.getUmvuthi();
        this.player = inv.player;
        this.inventory = screenContainer.getInventoryUmvuthi();
        this.hasTraded = this.umvuthi.hasTradedWith(inv.player);
        this.inventory.addListener(this);
    }

    protected void init() {
        super.init();
        String text = I18n.get((String)(this.hasTraded ? "entity.mowziesmobs.umvuthi.replenish.button.text" : "entity.mowziesmobs.umvuthi.trade.button.text"), (Object[])new Object[0]);
        this.grantButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)text), this::actionPerformed).width(204).pos(this.leftPos + 115, this.topPos + 52).size(56, 20).build());
        this.grantButton.active = this.hasTraded;
        this.updateButton();
    }

    protected void actionPerformed(Button button) {
        if (button == this.grantButton) {
            boolean satisfied;
            this.hasTraded = true;
            this.updateButton();
            PacketDistributor.sendToServer((CustomPacketPayload)new MessageUmvuthiTrade(this.umvuthi.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            if (!Minecraft.getInstance().isLocalServer() && !(satisfied = this.umvuthi.hasTradedWith(this.player)) && this.umvuthi.fulfillDesire(((ContainerUmvuthiTrade)this.menu).getSlot(0))) {
                this.umvuthi.rememberTrade(this.player);
                ((ContainerUmvuthiTrade)this.menu).broadcastChanges();
            }
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int x, int y) {
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)(this.hasTraded ? TEXTURE_REPLENISH : TEXTURE_TRADE));
        guiGraphics.blit(this.hasTraded ? TEXTURE_REPLENISH : TEXTURE_TRADE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        this.umvuthi.renderingInGUI = true;
        InventoryScreen.renderEntityInInventoryFollowsMouse((GuiGraphics)guiGraphics, (int)(this.leftPos + 8), (int)(this.topPos + 8), (int)(this.leftPos + 59), (int)(this.topPos + 69), (int)20, (float)0.25f, (float)x, (float)y, (LivingEntity)this.umvuthi);
        this.umvuthi.renderingInGUI = false;
    }

    protected void renderLabels(GuiGraphics guiGraphics, int x, int y) {
        String title = I18n.get((String)"entity.mowziesmobs.umvuthi.trade", (Object[])new Object[0]);
        guiGraphics.drawString(this.font, title, (int)((float)this.imageWidth / 2.0f - (float)this.font.width(title) / 2.0f) + 30, 6, 0x404040, false);
        guiGraphics.drawString(this.font, I18n.get((String)"container.inventory", (Object[])new Object[0]), 8, this.imageHeight - 96 + 2, 0x404040, false);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        ItemStack inSlot = this.inventory.getItem(0);
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, 0.0f, 100.0f);
        if (this.hasTraded) {
            guiGraphics.renderItem(this.output, this.leftPos + 106, this.topPos + 24);
            guiGraphics.renderItemDecorations(this.font, this.output, this.leftPos + 106, this.topPos + 24);
            if (this.isHovering(106, 24, 16, 16, mouseX, mouseY)) {
                guiGraphics.renderTooltip(this.font, this.output, mouseX, mouseY);
            }
        } else {
            guiGraphics.renderItem(this.umvuthi.getDesires(), this.leftPos + 68, this.topPos + 24);
            guiGraphics.renderItemDecorations(this.font, this.umvuthi.getDesires(), this.leftPos + 68, this.topPos + 24);
            guiGraphics.renderItem(this.output, this.leftPos + 134, this.topPos + 24);
            guiGraphics.renderItemDecorations(this.font, this.output, this.leftPos + 134, this.topPos + 24);
            if (this.isHovering(68, 24, 16, 16, mouseX, mouseY)) {
                guiGraphics.renderTooltip(this.font, this.umvuthi.getDesires(), mouseX, mouseY);
            } else if (this.isHovering(134, 24, 16, 16, mouseX, mouseY)) {
                guiGraphics.renderTooltip(this.font, this.output, mouseX, mouseY);
            }
        }
        if (this.grantButton.isMouseOver((double)mouseX, (double)mouseY)) {
            guiGraphics.renderComponentHoverEffect(this.font, this.getHoverText(), mouseX, mouseY);
        }
        guiGraphics.pose().popPose();
    }

    @Override
    public void onChange(Container inv) {
        this.grantButton.active = this.hasTraded || this.umvuthi.doesItemSatisfyDesire(inv.getItem(0));
    }

    private void updateButton() {
        if (this.hasTraded) {
            this.grantButton.setMessage((Component)Component.translatable((String)I18n.get((String)"entity.mowziesmobs.umvuthi.replenish.button.text", (Object[])new Object[0])));
            this.grantButton.setWidth(108);
            this.grantButton.setPosition(this.leftPos + 63, this.grantButton.getY());
        } else {
            this.grantButton.setMessage((Component)Component.translatable((String)I18n.get((String)"entity.mowziesmobs.umvuthi.trade.button.text", (Object[])new Object[0])));
        }
    }

    private Style getHoverText() {
        MutableComponent text = Component.translatable((String)I18n.get((String)(this.hasTraded ? "entity.mowziesmobs.umvuthi.replenish.button.hover" : "entity.mowziesmobs.umvuthi.trade.button.hover"), (Object[])new Object[0]));
        return text.getStyle().withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)text));
    }
}

