/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client;

import com.bobmowzie.mowziesmobs.client.render.block.SculptorBlockMarking;
import com.bobmowzie.mowziesmobs.client.sound.BlackPinkSound;
import com.bobmowzie.mowziesmobs.client.sound.BossMusicSound;
import com.bobmowzie.mowziesmobs.client.sound.EarthRumbleLoopSound;
import com.bobmowzie.mowziesmobs.client.sound.IGeomancyRumbler;
import com.bobmowzie.mowziesmobs.client.sound.IceBreathSound;
import com.bobmowzie.mowziesmobs.client.sound.NagaSwoopSound;
import com.bobmowzie.mowziesmobs.client.sound.SolarBeamSound;
import com.bobmowzie.mowziesmobs.client.sound.SpawnBoulderChargeSound;
import com.bobmowzie.mowziesmobs.client.sound.SunblockSound;
import com.bobmowzie.mowziesmobs.client.sound.SunstrikeSound;
import com.bobmowzie.mowziesmobs.server.ServerProxy;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntitySolarBeam;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntitySunstrike;
import com.bobmowzie.mowziesmobs.server.entity.naga.EntityNaga;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.TerrainParticle;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ClientProxy
extends ServerProxy {
    private static final List<SunblockSound> sunblockSounds = new ArrayList<SunblockSound>();
    public static final Map<UUID, ResourceLocation> bossBarRegistryNames = new HashMap<UUID, ResourceLocation>();
    public static final Long2ObjectMap<SculptorBlockMarking> sculptorMarkedBlocks = new Long2ObjectOpenHashMap();
    private Entity referencedMob = null;

    @Override
    public void playSunstrikeSound(EntitySunstrike strike) {
        Minecraft.getInstance().getSoundManager().play((SoundInstance)new SunstrikeSound(strike));
    }

    @Override
    public void playIceBreathSound(Entity entity) {
        Minecraft.getInstance().getSoundManager().play((SoundInstance)new IceBreathSound(entity));
    }

    @Override
    public void playBoulderChargeSound(LivingEntity player) {
        Minecraft.getInstance().getSoundManager().play((SoundInstance)new SpawnBoulderChargeSound(player));
    }

    @Override
    public void playNagaSwoopSound(EntityNaga naga) {
        Minecraft.getInstance().getSoundManager().play((SoundInstance)new NagaSwoopSound((Entity)naga));
    }

    @Override
    public void playBlackPinkSound(AbstractMinecart entity) {
        Minecraft.getInstance().getSoundManager().play((SoundInstance)new BlackPinkSound(entity));
    }

    @Override
    public void playSunblockSound(LivingEntity entity) {
        if (((Boolean)ConfigHandler.CLIENT.doUmvuthanaCraneHealSound.get()).booleanValue()) {
            sunblockSounds.removeIf(e -> e == null || e.isStopped());
            if (sunblockSounds.size() < 10) {
                SunblockSound sunblockSound = new SunblockSound(entity);
                sunblockSounds.add(sunblockSound);
                try {
                    Minecraft.getInstance().getSoundManager().play((SoundInstance)sunblockSound);
                }
                catch (ConcurrentModificationException concurrentModificationException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void playSolarBeamSound(EntitySolarBeam entity) {
        Minecraft.getInstance().getSoundManager().play((SoundInstance)new SolarBeamSound(entity, false));
        Minecraft.getInstance().getSoundManager().play((SoundInstance)new SolarBeamSound(entity, true));
    }

    @Override
    public void playGeomancyRumbleSound(IGeomancyRumbler rumbler) {
        Minecraft.getInstance().getSoundManager().play((SoundInstance)new EarthRumbleLoopSound(rumbler));
    }

    @Override
    public void minecartParticles(Level world, AbstractMinecart minecart, float scale, double x, double y, double z, BlockState state, BlockPos pos) {
        if (!(world instanceof ClientLevel)) {
            return;
        }
        ClientLevel clientLevel = (ClientLevel)world;
        int size = 3;
        float offset = -0.5f * scale;
        for (int ix = 0; ix < 3; ++ix) {
            for (int iy = 0; iy < 3; ++iy) {
                for (int iz = 0; iz < 3; ++iz) {
                    double dx = (double)ix / 3.0 * (double)scale;
                    double dy = (double)iy / 3.0 * (double)scale;
                    double dz = (double)iz / 3.0 * (double)scale;
                    Vec3 minecartMotion = minecart.getDeltaMovement();
                    Minecraft.getInstance().particleEngine.add((Particle)new TerrainParticle(this, clientLevel, x + dx + (double)offset, y + dy + (double)offset, z + dz + (double)offset, dx + minecartMotion.x(), dy + minecartMotion.y(), dz + minecartMotion.z(), state){}.updateSprite(state, pos));
                }
            }
        }
    }

    @Override
    public void setTPS(float tickRate) {
    }

    @Override
    public Entity getReferencedMob() {
        return this.referencedMob;
    }

    @Override
    public void setReferencedMob(Entity referencedMob) {
        this.referencedMob = referencedMob;
    }

    @Override
    public void sculptorMarkBlock(int id, BlockPos pos) {
        SculptorBlockMarking blockMarking = (SculptorBlockMarking)sculptorMarkedBlocks.get(pos.asLong());
        if (blockMarking == null) {
            blockMarking = new SculptorBlockMarking(pos);
            sculptorMarkedBlocks.put(pos.asLong(), (Object)blockMarking);
        } else {
            blockMarking.resetTick();
        }
    }

    @Override
    public void updateMarkedBlocks() {
        ObjectIterator iterator = sculptorMarkedBlocks.values().iterator();
        while (iterator.hasNext()) {
            SculptorBlockMarking blockMarking = (SculptorBlockMarking)iterator.next();
            int i = blockMarking.getTicks();
            if (i > blockMarking.getDuration()) {
                iterator.remove();
            }
            blockMarking.tick();
        }
    }

    @Override
    @Nullable
    public Player getLocalPlayer() {
        return Minecraft.getInstance().player;
    }

    @Override
    @Nullable
    public Level getClientLevel() {
        return Minecraft.getInstance().level;
    }

    @Override
    public void stopMusic() {
        Minecraft.getInstance().getMusicManager().stopPlaying();
    }

    @Override
    public void playMusic(BossMusicSound music) {
        Minecraft.getInstance().getSoundManager().play((SoundInstance)music);
    }
}

