/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.ironchest.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.progwml6.ironchest.client.IronChestsClientRegistration;
import com.progwml6.ironchest.client.model.IronChestsModels;
import com.progwml6.ironchest.client.model.inventory.ModelItem;
import com.progwml6.ironchest.common.block.IronChestsTypes;
import com.progwml6.ironchest.common.block.entity.ICrystalChest;
import com.progwml6.ironchest.common.block.regular.AbstractIronChestBlock;
import com.progwml6.ironchest.common.block.regular.entity.AbstractIronChestBlockEntity;
import com.progwml6.ironchest.common.block.trapped.entity.AbstractTrappedIronChestBlockEntity;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BrightnessCombiner;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class IronChestRenderer<T extends BlockEntity>
implements BlockEntityRenderer<T> {
    private final ModelPart lid;
    private final ModelPart bottom;
    private final ModelPart lock;
    private final BlockEntityRenderDispatcher renderer;
    private static final List<ModelItem> MODEL_ITEMS = Arrays.asList(new ModelItem(new Vector3f(0.3f, 0.45f, 0.3f), 3.0f), new ModelItem(new Vector3f(0.7f, 0.45f, 0.3f), 3.0f), new ModelItem(new Vector3f(0.3f, 0.45f, 0.7f), 3.0f), new ModelItem(new Vector3f(0.7f, 0.45f, 0.7f), 3.0f), new ModelItem(new Vector3f(0.3f, 0.1f, 0.3f), 3.0f), new ModelItem(new Vector3f(0.7f, 0.1f, 0.3f), 3.0f), new ModelItem(new Vector3f(0.3f, 0.1f, 0.7f), 3.0f), new ModelItem(new Vector3f(0.7f, 0.1f, 0.7f), 3.0f), new ModelItem(new Vector3f(0.5f, 0.32f, 0.5f), 3.0f));

    public IronChestRenderer(BlockEntityRendererProvider.Context context) {
        ModelPart modelPart = context.bakeLayer(IronChestsClientRegistration.IRON_CHEST);
        this.renderer = context.getBlockEntityRenderDispatcher();
        this.bottom = modelPart.getChild("iron_bottom");
        this.lid = modelPart.getChild("iron_lid");
        this.lock = modelPart.getChild("iron_lock");
    }

    public static LayerDefinition createLayerDefinition() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        partDefinition.addOrReplaceChild("iron_bottom", CubeListBuilder.create().texOffs(0, 19).addBox(1.0f, 0.0f, 1.0f, 14.0f, 10.0f, 14.0f), PartPose.ZERO);
        partDefinition.addOrReplaceChild("iron_lid", CubeListBuilder.create().texOffs(0, 0).addBox(1.0f, 0.0f, 0.0f, 14.0f, 5.0f, 14.0f), PartPose.offset((float)0.0f, (float)9.0f, (float)1.0f));
        partDefinition.addOrReplaceChild("iron_lock", CubeListBuilder.create().texOffs(0, 0).addBox(7.0f, -2.0f, 14.0f, 2.0f, 4.0f, 1.0f), PartPose.offset((float)0.0f, (float)9.0f, (float)1.0f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    public void render(T tileEntityIn, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLightIn, int combinedOverlayIn) {
        AbstractIronChestBlockEntity tileEntity = (AbstractIronChestBlockEntity)((Object)tileEntityIn);
        Level level = tileEntity.getLevel();
        boolean useTileEntityBlockState = level != null;
        BlockState blockState = useTileEntityBlockState ? tileEntity.getBlockState() : (BlockState)tileEntity.getBlockToUse().defaultBlockState().setValue((Property)AbstractIronChestBlock.FACING, (Comparable)Direction.SOUTH);
        Block block = blockState.getBlock();
        IronChestsTypes chestType = IronChestsTypes.IRON;
        IronChestsTypes actualType = AbstractIronChestBlock.getTypeFromBlock(block);
        if (actualType != null) {
            chestType = actualType;
        }
        if (block instanceof AbstractIronChestBlock) {
            AbstractIronChestBlock abstractChestBlock = (AbstractIronChestBlock)block;
            poseStack.pushPose();
            float f = ((Direction)blockState.getValue((Property)AbstractIronChestBlock.FACING)).toYRot();
            poseStack.translate(0.5, 0.5, 0.5);
            poseStack.mulPose(Axis.YP.rotationDegrees(-f));
            poseStack.translate(-0.5, -0.5, -0.5);
            DoubleBlockCombiner.NeighborCombineResult<? extends AbstractIronChestBlockEntity> neighborCombineResult = useTileEntityBlockState ? abstractChestBlock.combine(blockState, level, tileEntityIn.getBlockPos(), true) : DoubleBlockCombiner.Combiner::acceptNone;
            float openness = ((Float2FloatFunction)neighborCombineResult.apply(AbstractIronChestBlock.opennessCombiner(tileEntity))).get(partialTicks);
            openness = 1.0f - openness;
            openness = 1.0f - openness * openness * openness;
            int brightness = ((Int2IntFunction)neighborCombineResult.apply((DoubleBlockCombiner.Combiner)new BrightnessCombiner())).applyAsInt(combinedLightIn);
            boolean trapped = tileEntityIn instanceof AbstractTrappedIronChestBlockEntity;
            Material material = new Material(Sheets.CHEST_SHEET, IronChestsModels.chooseChestTexture(chestType, trapped));
            VertexConsumer vertexConsumer = material.buffer(bufferSource, RenderType::entityCutout);
            this.render(poseStack, vertexConsumer, this.lid, this.lock, this.bottom, openness, brightness, combinedOverlayIn);
            poseStack.popPose();
            if (chestType.isTransparent() && tileEntity instanceof ICrystalChest) {
                ICrystalChest crystalChest = (ICrystalChest)((Object)tileEntity);
                if (Vec3.atCenterOf((Vec3i)tileEntityIn.getBlockPos()).closerThan((Position)this.renderer.camera.getPosition(), 128.0)) {
                    float rotation = (float)(360.0 * (double)(System.currentTimeMillis() & 0x3FFFL) / 16383.0) - partialTicks;
                    for (int j = 0; j < MODEL_ITEMS.size() - 1; ++j) {
                        IronChestRenderer.renderItem(poseStack, bufferSource, (ItemStack)crystalChest.getTopItems().get(j), MODEL_ITEMS.get(j), rotation, combinedLightIn);
                    }
                }
            }
        }
    }

    private void render(PoseStack poseStack, VertexConsumer vertexConsumer, ModelPart lid, ModelPart lock, ModelPart bottom, float openness, int brightness, int combinedOverlayIn) {
        lock.xRot = lid.xRot = -(openness * 1.5707964f);
        lid.render(poseStack, vertexConsumer, brightness, combinedOverlayIn);
        lock.render(poseStack, vertexConsumer, brightness, combinedOverlayIn);
        bottom.render(poseStack, vertexConsumer, brightness, combinedOverlayIn);
    }

    public static void renderItem(PoseStack matrices, MultiBufferSource buffer, ItemStack item, ModelItem modelItem, float rotation, int light) {
        if (item.isEmpty()) {
            return;
        }
        matrices.pushPose();
        Vector3f center = modelItem.getCenter();
        matrices.translate(center.x(), center.y(), center.z());
        matrices.mulPose(Axis.YP.rotationDegrees(rotation));
        float scale = modelItem.getSizeScaled();
        matrices.scale(scale, scale, scale);
        Minecraft.getInstance().getItemRenderer().renderStatic(item, ItemDisplayContext.NONE, light, OverlayTexture.NO_OVERLAY, matrices, buffer, null, 0);
        matrices.popPose();
    }

    public AABB getRenderBoundingBox(T blockEntity) {
        BlockPos pos = blockEntity.getBlockPos();
        return AABB.encapsulatingFullBlocks((BlockPos)pos.offset(-1, 0, -1), (BlockPos)pos.offset(1, 1, 1));
    }
}

