/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.types.habitats;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dmr.DragonMounts.types.habitats.Habitat;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public record NearbyBlocksHabitat(float multiplier, TagKey<Block> tag) implements Habitat
{
    public static final Codec<NearbyBlocksHabitat> CODEC = RecordCodecBuilder.create(instance -> instance.group(Habitat.withMultiplier(0.5f, NearbyBlocksHabitat::multiplier), (App)TagKey.codec((ResourceKey)Registries.BLOCK).fieldOf("block_tag").forGetter(NearbyBlocksHabitat::tag)).apply((Applicative)instance, NearbyBlocksHabitat::new));

    @Override
    public int getHabitatPoints(Level level, BlockPos basePos) {
        Stream blockPositions = BlockPos.betweenClosedStream((BlockPos)basePos.offset(1, 1, 1), (BlockPos)basePos.offset(-1, -1, -1));
        Stream<BlockPos> blocks = blockPositions.filter(s -> !level.isEmptyBlock(s));
        Stream<BlockState> states = blocks.map(arg_0 -> ((Level)level).getBlockState(arg_0));
        Stream<BlockState> filteredStates = states.filter(s -> s.is(this.tag));
        return (int)((float)filteredStates.count() * this.multiplier);
    }

    @Override
    public String type() {
        return Habitat.NEARBY_BLOCKS;
    }
}

