/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.types.habitats;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dmr.DragonMounts.types.habitats.BiomeHabitat;
import dmr.DragonMounts.types.habitats.DragonBreathHabitat;
import dmr.DragonMounts.types.habitats.FluidHabitat;
import dmr.DragonMounts.types.habitats.HeightHabitat;
import dmr.DragonMounts.types.habitats.LightHabitat;
import dmr.DragonMounts.types.habitats.NearbyBlocksHabitat;
import dmr.DragonMounts.types.habitats.PickyHabitat;
import dmr.DragonMounts.types.habitats.TimeOfDayHabitat;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;

public interface Habitat {
    public static final Map<String, MapCodec<? extends Habitat>> REGISTRY = new HashMap<String, MapCodec<? extends Habitat>>();
    public static final Codec<Habitat> CODEC = Codec.STRING.dispatch(Habitat::type, REGISTRY::get);
    public static final String PICKY = Habitat.register("picky", PickyHabitat.CODEC);
    public static final String BIOMES = Habitat.register("biome", BiomeHabitat.CODEC);
    public static final String IN_FLUID = Habitat.register("in_fluid", FluidHabitat.CODEC);
    public static final String WORLD_HEIGHT = Habitat.register("world_height", HeightHabitat.CODEC);
    public static final String LIGHT = Habitat.register("light", LightHabitat.CODEC);
    public static final String NEARBY_BLOCKS = Habitat.register("nearby_blocks", NearbyBlocksHabitat.CODEC);
    public static final String DRAGON_BREATH = Habitat.register("dragon_breath", DragonBreathHabitat.CODEC);
    public static final String TIME_OF_DAY = Habitat.register("time", TimeOfDayHabitat.CODEC);

    public static String register(String name, Codec<? extends Habitat> codec) {
        REGISTRY.put(name, (MapCodec<? extends Habitat>)MapCodec.assumeMapUnsafe(codec));
        return name;
    }

    public static <T extends Habitat> RecordCodecBuilder<T, Integer> withPoints(int defaultTo, Function<T, Integer> getter) {
        return Codec.INT.optionalFieldOf("points", (Object)defaultTo).forGetter(getter);
    }

    public static <T extends Habitat> RecordCodecBuilder<T, Float> withMultiplier(float defaultTo, Function<T, Float> getter) {
        return Codec.FLOAT.optionalFieldOf("point_multiplier", (Object)Float.valueOf(defaultTo)).forGetter(getter);
    }

    public int getHabitatPoints(Level var1, BlockPos var2);

    public String type();
}

