/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.types.dragonBreeds;

import com.google.gson.annotations.SerializedName;
import dmr.DragonMounts.server.entity.TameableDragonEntity;
import dmr.DragonMounts.types.abilities.types.Ability;
import dmr.DragonMounts.types.breath.DragonBreathType;
import dmr.DragonMounts.types.dragonBreeds.DragonHybridBreed;
import dmr.DragonMounts.types.habitats.Habitat;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.pathfinder.PathType;

public interface IDragonBreed {
    default public boolean isHybrid() {
        return this instanceof DragonHybridBreed;
    }

    default public void initialize(TameableDragonEntity dragon) {
        this.applyAttributes(dragon);
        for (Ability a : this.getAbilities()) {
            a.initialize(dragon);
        }
        if (this.getImmunities().contains("drown")) {
            dragon.setPathfindingMalus(PathType.WATER, 0.0f);
        }
    }

    default public void close(TameableDragonEntity dragon) {
        dragon.getAttributes().assignAllValues(new AttributeMap(TameableDragonEntity.createAttributes().build()));
        for (Ability a : this.getAbilities()) {
            a.close(dragon);
        }
    }

    default public void tick(TameableDragonEntity dragon) {
        for (Ability a : this.getAbilities()) {
            a.tick(dragon);
        }
    }

    default public void onMove(TameableDragonEntity dragon) {
        for (Ability a : this.getAbilities()) {
            a.onMove(dragon);
        }
    }

    default public void applyAttributes(TameableDragonEntity dragon) {
        float healthPercentile = dragon.getHealth() / dragon.getMaxHealth();
        this.getAttributes().forEach((att, value) -> {
            AttributeInstance inst;
            Optional attr = BuiltInRegistries.ATTRIBUTE.getHolder(att);
            if (attr.isPresent() && (inst = dragon.getAttribute((Holder)attr.get())) != null) {
                inst.setBaseValue(value.doubleValue());
            }
        });
        for (Ability ability : this.getAbilities()) {
            if (ability.getAttributes() == null) continue;
            ability.getAttributes().forEach((att, value) -> {
                AttributeInstance inst;
                Optional attr = BuiltInRegistries.ATTRIBUTE.getHolder(att);
                if (attr.isPresent() && (inst = dragon.getAttribute((Holder)attr.get())) != null) {
                    inst.addPermanentModifier(new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"dmr", (String)ability.type()), value.doubleValue(), AttributeModifier.Operation.ADD_VALUE));
                }
            });
        }
        dragon.setHealth(dragon.getMaxHealth() * healthPercentile);
    }

    public Component getName();

    public ResourceLocation getResourceLocation();

    public ResourceLocation getDragonModelLocation();

    public ResourceLocation getDragonAnimationLocation();

    public ResourceLocation getInventoryTexture();

    public String getArmorTypeId();

    public int getPrimaryColor();

    public int getSecondaryColor();

    public DragonBreathType getBreathType();

    public String getId();

    public void setId(String var1);

    public ResourceLocation getDeathLootTable();

    public SoundEvent getAmbientSound();

    public int getHatchTime();

    public int getGrowthTime();

    public float getSizeModifier();

    public List<String> getImmunities();

    public Map<ResourceLocation, Double> getAttributes();

    public List<Habitat> getHabitats();

    public List<Ability> getAbilities();

    public List<Item> getTamingItems();

    public List<Item> getBreedingItems();

    public ParticleOptions getHatchParticles();

    public List<String> getAccessories();

    public List<LootTableEntry> getLootTable();

    public List<Variant> getVariants();

    public record Variant(@SerializedName(value="id") String id, @SerializedName(value="texture") ResourceLocation skinTexture, @SerializedName(value="saddle_texture") ResourceLocation saddleTexture, @SerializedName(value="glow_texture") ResourceLocation glowTexture, @SerializedName(value="egg_texture") ResourceLocation eggTexture, @SerializedName(value="breath_type") DragonBreathType breathType, @SerializedName(value="primary_color") String primaryColor, @SerializedName(value="secondary_color") String secondaryColor, @SerializedName(value="size_modifier") float sizeModifier) {
        public int getPrimaryColor() {
            return this.primaryColor == null ? 0 : Integer.parseInt(this.primaryColor, 16);
        }

        public int getSecondaryColor() {
            return this.secondaryColor == null ? 0 : Integer.parseInt(this.secondaryColor, 16);
        }
    }

    public record LootTableEntry(@SerializedName(value="table") ResourceLocation table, @SerializedName(value="chance") float chance, @SerializedName(value="min") int minAmount, @SerializedName(value="max") int maxAmount) {
    }
}

