/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.types.dragonBreeds;

import com.google.gson.annotations.SerializedName;
import dmr.DragonMounts.DMR;
import dmr.DragonMounts.config.ServerConfig;
import dmr.DragonMounts.registry.DragonBreathRegistry;
import dmr.DragonMounts.registry.DragonBreedsRegistry;
import dmr.DragonMounts.registry.ModComponents;
import dmr.DragonMounts.types.abilities.types.Ability;
import dmr.DragonMounts.types.breath.DragonBreathType;
import dmr.DragonMounts.types.dragonBreeds.IDragonBreed;
import dmr.DragonMounts.types.habitats.Habitat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class DragonBreed
implements IDragonBreed {
    private String id;
    @SerializedName(value="ambient_sound")
    private SoundEvent ambientSound;
    @SerializedName(value="death_loot")
    private ResourceLocation deathLootTable;
    @SerializedName(value="hatch_time")
    private int hatchTime = -1;
    @SerializedName(value="growth_time")
    private int growthTime = -1;
    @SerializedName(value="size_modifier")
    private float sizeModifier = -1.0f;
    @SerializedName(value="primary_color")
    private String primaryColor;
    @SerializedName(value="secondary_color")
    private String secondaryColor;
    @SerializedName(value="inventory_texture")
    private ResourceLocation inventoryTexture;
    private final ResourceLocation defaultInventoryTexture = ResourceLocation.parse((String)"textures/block/stone.png");
    @SerializedName(value="breath_type")
    private String breathType;
    @SerializedName(value="immunities")
    private List<String> immunities = new ArrayList<String>();
    @SerializedName(value="attributes")
    private Map<ResourceLocation, Double> attributes = new HashMap<ResourceLocation, Double>();
    @SerializedName(value="habitats")
    private List<Habitat> habitats = new ArrayList<Habitat>();
    @SerializedName(value="abilities")
    private List<Ability> abilities = new ArrayList<Ability>();
    @SerializedName(value="taming_items")
    private List<Item> tamingItems = new ArrayList<Item>();
    @SerializedName(value="breeding_items")
    private List<Item> breedingItems = new ArrayList<Item>();
    @SerializedName(value="hatch_particles")
    private ParticleOptions hatchParticles;
    @SerializedName(value="accessories")
    private List<String> accessories = new ArrayList<String>();
    @SerializedName(value="loot_tables")
    private List<IDragonBreed.LootTableEntry> lootTable = new ArrayList<IDragonBreed.LootTableEntry>();
    @SerializedName(value="model_location")
    private ResourceLocation dragonModelLocation;
    @SerializedName(value="animation_location")
    private ResourceLocation dragonAnimationLocation;
    @SerializedName(value="armor_type")
    private String armorTypeId = "default";
    @SerializedName(value="variants")
    private IDragonBreed.Variant[] variants;
    private List<IDragonBreed.Variant> cachedVariants = null;

    private <T> T getValueOrDefault(T value, T defaultValue) {
        return value != null && (!(value instanceof Number) || ((Number)value).doubleValue() > 0.0) ? value : defaultValue;
    }

    @Override
    public int getHatchTime() {
        return this.getValueOrDefault(this.hatchTime, ServerConfig.HATCH_TIME_CONFIG.intValue());
    }

    @Override
    public int getGrowthTime() {
        return this.getValueOrDefault(this.growthTime, (int)(ServerConfig.GROWTH_TIME_CONFIG * 20L));
    }

    @Override
    public float getSizeModifier() {
        return this.getValueOrDefault(Float.valueOf(this.sizeModifier), Float.valueOf((float)ServerConfig.SIZE_MODIFIER)).floatValue();
    }

    @Override
    public int getPrimaryColor() {
        return this.primaryColor == null ? 0 : Integer.parseInt(this.primaryColor, 16);
    }

    @Override
    public int getSecondaryColor() {
        return this.secondaryColor == null ? 0 : Integer.parseInt(this.secondaryColor, 16);
    }

    @Override
    public ResourceLocation getInventoryTexture() {
        return this.inventoryTexture != null ? this.inventoryTexture : this.defaultInventoryTexture;
    }

    @Override
    public DragonBreathType getBreathType() {
        return DragonBreathRegistry.getBreathType(this.breathType);
    }

    @Override
    public Component getName() {
        return Component.translatable((String)("dmr.dragon_breed." + this.getId()));
    }

    @Override
    public ResourceLocation getResourceLocation() {
        return DMR.id(this.getId());
    }

    @Override
    public List<IDragonBreed.Variant> getVariants() {
        if (this.cachedVariants == null) {
            this.cachedVariants = this.variants != null ? List.of(this.variants) : List.of();
        }
        return List.copyOf(this.cachedVariants);
    }

    public static IDragonBreed getDragonType(ItemStack stack) {
        String breedId = (String)stack.get(ModComponents.DRAGON_BREED);
        return DragonBreedsRegistry.getDragonBreed(breedId);
    }

    public static IDragonBreed.Variant getDragonTypeVariant(ItemStack stack) {
        IDragonBreed breed = DragonBreed.getDragonType(stack);
        String variantId = (String)stack.get(ModComponents.DRAGON_VARIANT);
        if (breed != null) {
            return breed.getVariants().stream().filter(variant -> variant.id().equals(variantId)).findFirst().orElse(null);
        }
        return null;
    }

    public static void setDragonType(ItemStack stack, IDragonBreed type) {
        if (stack == null || type == null) {
            return;
        }
        stack.set(ModComponents.DRAGON_BREED, (Object)type.getId());
    }

    public static void setDragonTypeVariant(ItemStack stack, IDragonBreed type, IDragonBreed.Variant variant) {
        DragonBreed.setDragonType(stack, type);
        stack.set(ModComponents.DRAGON_VARIANT, (Object)variant.id());
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DragonBreed)) {
            return false;
        }
        DragonBreed other = (DragonBreed)o;
        return other.canEqual(this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DragonBreed;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Generated
    public String toString() {
        return "DragonBreed(id=" + this.getId() + ")";
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public SoundEvent getAmbientSound() {
        return this.ambientSound;
    }

    @Override
    @Generated
    public ResourceLocation getDeathLootTable() {
        return this.deathLootTable;
    }

    @Generated
    public ResourceLocation getDefaultInventoryTexture() {
        return this.defaultInventoryTexture;
    }

    @Override
    @Generated
    public List<String> getImmunities() {
        return this.immunities;
    }

    @Override
    @Generated
    public Map<ResourceLocation, Double> getAttributes() {
        return this.attributes;
    }

    @Override
    @Generated
    public List<Habitat> getHabitats() {
        return this.habitats;
    }

    @Override
    @Generated
    public List<Ability> getAbilities() {
        return this.abilities;
    }

    @Override
    @Generated
    public List<Item> getTamingItems() {
        return this.tamingItems;
    }

    @Override
    @Generated
    public List<Item> getBreedingItems() {
        return this.breedingItems;
    }

    @Override
    @Generated
    public ParticleOptions getHatchParticles() {
        return this.hatchParticles;
    }

    @Override
    @Generated
    public List<String> getAccessories() {
        return this.accessories;
    }

    @Override
    @Generated
    public List<IDragonBreed.LootTableEntry> getLootTable() {
        return this.lootTable;
    }

    @Override
    @Generated
    public ResourceLocation getDragonModelLocation() {
        return this.dragonModelLocation;
    }

    @Override
    @Generated
    public ResourceLocation getDragonAnimationLocation() {
        return this.dragonAnimationLocation;
    }

    @Override
    @Generated
    public String getArmorTypeId() {
        return this.armorTypeId;
    }

    @Generated
    public List<IDragonBreed.Variant> getCachedVariants() {
        return this.cachedVariants;
    }

    @Override
    @Generated
    public void setId(String id) {
        this.id = id;
    }
}

