/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.types.abilities.types;

import com.mojang.serialization.Codec;
import dmr.DragonMounts.registry.DragonAbilities;
import dmr.DragonMounts.server.entity.TameableDragonEntity;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public interface Ability {
    public static final Codec<Ability> CODEC = Codec.STRING.dispatch(Ability::type, DragonAbilities.REGISTRY::get);

    public String type();

    default public Component getTranslatedName() {
        return Component.translatable((String)("dmr.ability." + this.type() + ".name"));
    }

    default public Component getTranslatedDescription() {
        return Component.translatable((String)("dmr.ability." + this.type() + ".description"));
    }

    default public void initialize(TameableDragonEntity dragon) {
    }

    default public void close(TameableDragonEntity dragon) {
    }

    default public void tick(TameableDragonEntity dragon) {
    }

    default public void onMove(TameableDragonEntity dragon) {
    }

    default public Map<ResourceLocation, Double> getAttributes() {
        return null;
    }
}

