/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.types.abilities.dragon_types.ice_dragon;

import dmr.DragonMounts.server.entity.TameableDragonEntity;
import dmr.DragonMounts.types.abilities.types.Ability;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.pathfinder.PathType;

public class FrostWalkerAbility
implements Ability {
    @Override
    public void initialize(TameableDragonEntity dragon) {
        dragon.setPathfindingMalus(PathType.WATER, 0.0f);
    }

    @Override
    public void close(TameableDragonEntity dragon) {
        dragon.setPathfindingMalus(PathType.WATER, PathType.WATER.getMalus());
    }

    @Override
    public void onMove(TameableDragonEntity dragon) {
        if (!dragon.level.isClientSide() && dragon.isAdult()) {
            HolderLookup.RegistryLookup registrylookup = dragon.level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT);
            Holder.Reference enchant = registrylookup.getOrThrow(Enchantments.FROST_WALKER);
            ((Enchantment)enchant.value()).runLocationChangedEffects((ServerLevel)dragon.level, (int)Math.max(3.0f * dragon.getScale(), 1.0f), new EnchantedItemInUse(ItemStack.EMPTY, null, null, i -> {}), (LivingEntity)dragon);
        }
    }

    @Override
    public void tick(TameableDragonEntity dragon) {
        if (!dragon.level.isClientSide() && dragon.isAdult()) {
            HolderLookup.RegistryLookup registrylookup = dragon.level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT);
            Holder.Reference enchant = registrylookup.getOrThrow(Enchantments.FROST_WALKER);
            ((Enchantment)enchant.value()).runLocationChangedEffects((ServerLevel)dragon.level, (int)Math.max(3.0f * dragon.getScale(), 1.0f), new EnchantedItemInUse(ItemStack.EMPTY, null, null, i -> {}), (LivingEntity)dragon);
        }
    }

    @Override
    public String type() {
        return "frost_walker";
    }
}

