/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.server.worlddata;

import dmr.DragonMounts.config.ServerConfig;
import dmr.DragonMounts.server.inventory.DragonInventoryHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class DragonWorldData
extends SavedData {
    private static final String name = "dmr_dragon_world_data";
    public Map<UUID, Integer> deathDelay = new HashMap<UUID, Integer>();
    public Map<UUID, String> deathMessages = new HashMap<UUID, String>();
    public List<UUID> deadDragons = new ArrayList<UUID>();
    public Map<UUID, DragonInventoryHandler.DragonInventory> dragonInventories = new HashMap<UUID, DragonInventoryHandler.DragonInventory>();
    public Map<UUID, DragonHistory> dragonHistory = new LinkedHashMap<UUID, DragonHistory>(){

        @Override
        public boolean removeEldestEntry(Map.Entry<UUID, DragonHistory> eldest) {
            return this.size() > ServerConfig.DRAGON_HISTORY_SIZE;
        }
    };

    public void setDirty(boolean dirty) {
        super.setDirty(dirty);
        if (!dirty) {
            this.dragonInventories.forEach((uuid, inventory) -> {
                if (inventory != null) {
                    inventory.setDirty(false);
                }
            });
        }
    }

    public boolean isDirty() {
        return super.isDirty() || this.dragonInventories.values().stream().anyMatch(DragonInventoryHandler.DragonInventory::isDirty);
    }

    public static DragonWorldData load(CompoundTag nbt, HolderLookup.Provider provider) {
        DragonWorldData data = new DragonWorldData();
        int num = nbt.getInt("num");
        ListTag listtag = nbt.getList("deadDragons", 10);
        for (int i = 0; i < num; ++i) {
            CompoundTag compoundtag = listtag.getCompound(i);
            if (compoundtag == null || compoundtag.isEmpty()) continue;
            UUID uuid = compoundtag.getUUID("uuid");
            int delay = compoundtag.getInt("delay");
            String message = compoundtag.getString("message");
            data.deadDragons.add(uuid);
            data.deathDelay.put(uuid, delay);
            data.deathMessages.put(uuid, message);
        }
        CompoundTag dragonHistory = nbt.getCompound("dragonHistory");
        for (String key : dragonHistory.getAllKeys()) {
            CompoundTag historyTag = dragonHistory.getCompound(key);
            UUID uuid = UUID.fromString(key);
            long time = historyTag.getLong("time");
            String playerName = historyTag.getString("playerName");
            MutableComponent dragonName = Component.Serializer.fromJson((String)historyTag.getString("dragonName"), (HolderLookup.Provider)provider);
            CompoundTag compoundTag = historyTag.getCompound("compoundTag");
            data.dragonHistory.put(uuid, new DragonHistory(uuid, time, playerName, (Component)dragonName, compoundTag));
        }
        CompoundTag inventories = nbt.getCompound("dragonInventories");
        for (String key : inventories.getAllKeys()) {
            CompoundTag inventoryTag = inventories.getCompound(key);
            UUID uuid = UUID.fromString(key);
            DragonInventoryHandler.DragonInventory inventory = new DragonInventoryHandler.DragonInventory(provider);
            inventory.readNBT(inventoryTag);
            data.dragonInventories.put(uuid, inventory);
        }
        return data;
    }

    public CompoundTag save(CompoundTag pCompoundTag, HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        tag.putInt("num", this.deathDelay.size());
        ListTag listtag = new ListTag();
        for (UUID uUID : this.deadDragons) {
            CompoundTag compoundTag = new CompoundTag();
            tag.putUUID("uuid", uUID);
            tag.putInt("delay", this.deathDelay.getOrDefault(uUID, 0).intValue());
            tag.putString("message", this.deathMessages.getOrDefault(uUID, ""));
            listtag.add((Object)compoundTag);
        }
        tag.put("deadDragons", (Tag)listtag);
        CompoundTag dragonHistoryTag = new CompoundTag();
        for (Map.Entry<UUID, DragonHistory> entry : this.dragonHistory.entrySet()) {
            UUID uuid = entry.getKey();
            DragonHistory history = entry.getValue();
            CompoundTag historyTag = new CompoundTag();
            historyTag.putLong("time", history.time().longValue());
            historyTag.putString("playerName", history.playerName());
            historyTag.putString("dragonName", Component.Serializer.toJson((Component)history.dragonName(), (HolderLookup.Provider)provider));
            historyTag.put("compoundTag", (Tag)history.compoundTag());
            dragonHistoryTag.put(uuid.toString(), (Tag)historyTag);
        }
        tag.put("dragonHistory", (Tag)dragonHistoryTag);
        CompoundTag compoundTag = new CompoundTag();
        for (Map.Entry entry : this.dragonInventories.entrySet().stream().filter(e -> e.getKey() != null).toList()) {
            UUID uuid = (UUID)entry.getKey();
            DragonInventoryHandler.DragonInventory inventory = (DragonInventoryHandler.DragonInventory)entry.getValue();
            if (inventory == null || inventory.inventory.getItems().stream().allMatch(ItemStack::isEmpty)) continue;
            compoundTag.put(uuid.toString(), (Tag)inventory.writeNBT());
        }
        tag.put("dragonInventories", (Tag)compoundTag);
        return tag;
    }

    public static DragonWorldData getInstance(Level level) {
        if (!(level instanceof ServerLevel)) {
            throw new RuntimeException("Attempted to get the data from a client world. This is wrong.");
        }
        DimensionDataStorage storage = ((ServerLevel)level).getDataStorage();
        return (DragonWorldData)storage.computeIfAbsent(DragonWorldData.factory(), name);
    }

    public static SavedData.Factory<DragonWorldData> factory() {
        return new SavedData.Factory(DragonWorldData::new, DragonWorldData::load, DataFixTypes.LEVEL);
    }

    public record DragonHistory(UUID id, Long time, String playerName, Component dragonName, CompoundTag compoundTag) {
    }
}

