/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.server.items;

import dmr.DragonMounts.client.gui.CommandMenu.CommandMenuScreen;
import dmr.DragonMounts.client.handlers.CommandOverlayHandler;
import dmr.DragonMounts.common.capability.DragonOwnerCapability;
import dmr.DragonMounts.common.handlers.DragonWhistleHandler;
import dmr.DragonMounts.network.packets.CompleteDataSync;
import dmr.DragonMounts.registry.DragonBreedsRegistry;
import dmr.DragonMounts.registry.ModCapabilities;
import dmr.DragonMounts.registry.ModItems;
import dmr.DragonMounts.server.entity.TameableDragonEntity;
import dmr.DragonMounts.types.dragonBreeds.IDragonBreed;
import dmr.DragonMounts.util.PlayerStateUtils;
import java.util.List;
import lombok.Generated;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;

public class DragonWhistleItem
extends Item {
    private final DyeColor color;

    public DragonWhistleItem(Item.Properties pProperties, DyeColor color) {
        super(pProperties);
        this.color = color;
    }

    public static ItemStack getWhistleItem(DyeColor color) {
        return DragonWhistleItem.getWhistleItem(color, 1);
    }

    public static ItemStack getWhistleItem(DyeColor color, int count) {
        return new ItemStack((ItemLike)ModItems.DRAGON_WHISTLES.get(color.getId()).get(), count);
    }

    public void inventoryTick(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        super.inventoryTick(pStack, pLevel, pEntity, pSlotId, pIsSelected);
        if (pEntity instanceof Player) {
            Player player = (Player)pEntity;
            DragonOwnerCapability state = (DragonOwnerCapability)player.getData(ModCapabilities.PLAYER_CAPABILITY);
            if (state.respawnDelays.containsKey(this.color.getId()) && !player.getCooldowns().isOnCooldown((Item)this)) {
                player.getCooldowns().addCooldown((Item)this, state.respawnDelays.get(this.color.getId()).intValue());
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        LocalPlayer player = Minecraft.getInstance().player;
        assert (player != null);
        DragonOwnerCapability state = PlayerStateUtils.getHandler((Player)player);
        CompoundTag nbt = state.dragonNBTs.get(this.color.getId());
        if (nbt == null) {
            return;
        }
        String breed = nbt.getString("breed");
        IDragonBreed dragonBreed = DragonBreedsRegistry.getDragonBreed(breed);
        if (dragonBreed != null) {
            Object name = Component.translatable((String)("dmr.dragon_breed." + breed)).getString();
            if (nbt.contains("CustomName")) {
                name = nbt.getString("CustomName").replace("\"", "") + " (" + (String)name + ")";
            }
            tooltipComponents.add((Component)Component.translatable((String)"dmr.dragon_summon.tooltip.1", (Object[])new Object[]{name}).withStyle(ChatFormatting.GRAY).withStyle(ChatFormatting.ITALIC));
        }
        if (state.respawnDelays.containsKey(this.color.getId()) && state.respawnDelays.get(this.color.getId()) > 0) {
            tooltipComponents.add((Component)Component.translatable((String)"dmr.dragon_summon.tooltip.2", (Object[])new Object[]{state.respawnDelays.get(this.color.getId()) / 20}).withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.RED));
        }
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        if (!pPlayer.isShiftKeyDown()) {
            DragonOwnerCapability state = PlayerStateUtils.getHandler(pPlayer);
            CompoundTag nbt = state.dragonNBTs.get(this.color.getId());
            if (nbt == null) {
                if (!pPlayer.level.isClientSide) {
                    pPlayer.displayClientMessage((Component)Component.translatable((String)"dmr.dragon_call.nodragon").withStyle(ChatFormatting.RED), true);
                }
                return InteractionResultHolder.pass((Object)pPlayer.getItemInHand(pUsedHand));
            }
            if (pPlayer.level.isClientSide) {
                CommandOverlayHandler.resetTimer();
                CommandMenuScreen.activate();
            }
            return InteractionResultHolder.pass((Object)pPlayer.getItemInHand(pUsedHand));
        }
        return super.use(pLevel, pPlayer, pUsedHand);
    }

    public InteractionResult interactLivingEntity(ItemStack pStack, Player pPlayer, LivingEntity pInteractionTarget, InteractionHand pUsedHand) {
        TameableDragonEntity dragon;
        if (pPlayer.level.isClientSide) {
            return InteractionResult.PASS;
        }
        if (pInteractionTarget instanceof TameableDragonEntity && (dragon = (TameableDragonEntity)pInteractionTarget).isTame() && dragon.isAdult() && dragon.isOwnedBy((LivingEntity)pPlayer)) {
            DragonOwnerCapability cap = (DragonOwnerCapability)pPlayer.getData(ModCapabilities.PLAYER_CAPABILITY);
            if (cap.dragonInstances.containsKey(this.color.getId())) {
                DragonWhistleHandler.DragonInstance dragonInstance = cap.dragonInstances.get(this.color.getId());
                if (!pPlayer.isShiftKeyDown()) {
                    return InteractionResult.PASS;
                }
                if (!dragonInstance.getUUID().equals(dragon.getDragonUUID())) {
                    pPlayer.displayClientMessage((Component)Component.translatable((String)"dmr.dragon_call.unlink_first"), true);
                } else {
                    cap.dragonInstances.remove(this.color.getId());
                    cap.dragonNBTs.remove(this.color.getId());
                    cap.respawnDelays.remove(this.color.getId());
                    pPlayer.displayClientMessage((Component)Component.translatable((String)"dmr.dragon_call.unlink_success"), true);
                    PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)pPlayer), (CustomPacketPayload)new CompleteDataSync(pPlayer), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                return InteractionResult.SUCCESS;
            }
            DragonWhistleHandler.setDragon(pPlayer, dragon, this.color.getId());
            PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)pPlayer), (CustomPacketPayload)new CompleteDataSync(pPlayer), (CustomPacketPayload[])new CustomPacketPayload[0]);
            pPlayer.displayClientMessage((Component)Component.translatable((String)"dmr.dragon_call.link_success", (Object[])new Object[]{dragon.getDisplayName().getString()}), true);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Generated
    public DyeColor getColor() {
        return this.color;
    }
}

