/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.server.events;

import dmr.DragonMounts.config.ServerConfig;
import dmr.DragonMounts.registry.DragonArmorRegistry;
import dmr.DragonMounts.registry.DragonBreedsRegistry;
import dmr.DragonMounts.registry.ModComponents;
import dmr.DragonMounts.registry.ModItems;
import dmr.DragonMounts.types.armor.DragonArmor;
import dmr.DragonMounts.types.dragonBreeds.IDragonBreed;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetComponentsFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.LootTableLoadEvent;

public class LootTableInject {
    public static void firstLoadInjectBreeds(LevelAccessor level) {
        MinecraftServer server = level.getServer();
        if (server != null) {
            for (IDragonBreed breed : DragonBreedsRegistry.getDragonBreeds()) {
                if (breed.isHybrid()) continue;
                for (IDragonBreed.LootTableEntry entry : breed.getLootTable()) {
                    ResourceKey newTableKey = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)entry.table());
                    LootTable table = server.reloadableRegistries().getLootTable(newTableKey);
                    if (table == LootTable.EMPTY) continue;
                    LootPool lootPool = LootTableInject.injectEggLoot(breed, entry, null);
                    breed.getVariants().forEach(variant -> {
                        LootPool variantLootPool = LootTableInject.injectEggLoot(breed, entry, variant);
                        if (table.getPool(variantLootPool.getName()) != null) {
                            table.removePool(variantLootPool.getName());
                        }
                        table.addPool(variantLootPool);
                    });
                    if (table.getPool(lootPool.getName()) != null) {
                        table.removePool(lootPool.getName());
                    }
                    table.addPool(lootPool);
                }
            }
        }
    }

    public static void firstLoadInjectArmor(LevelAccessor level) {
        MinecraftServer server = level.getServer();
        if (server != null) {
            for (DragonArmor armor : DragonArmorRegistry.getDragonArmors()) {
                for (IDragonBreed.LootTableEntry entry : armor.getLootTable()) {
                    ResourceKey newTableKey = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)entry.table());
                    LootTable table = server.reloadableRegistries().getLootTable(newTableKey);
                    if (table == LootTable.EMPTY) continue;
                    LootPool lootPool = LootTableInject.injectArmorLoot(armor, entry);
                    if (table.getPool(lootPool.getName()) != null) {
                        table.removePool(lootPool.getName());
                    }
                    table.addPool(lootPool);
                }
            }
        }
    }

    public static LootPool injectEggLoot(IDragonBreed breed, IDragonBreed.LootTableEntry entry, IDragonBreed.Variant variant) {
        LootPoolSingletonContainer.Builder lootItemBuilder = LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.DRAGON_EGG_BLOCK_ITEM.get())).apply((LootItemFunction.Builder)SetComponentsFunction.setComponent(ModComponents.DRAGON_BREED.get(), (Object)breed.getId()));
        if (variant != null) {
            lootItemBuilder.apply((LootItemFunction.Builder)SetComponentsFunction.setComponent(ModComponents.DRAGON_VARIANT.get(), (Object)variant.id()));
        }
        double chanceMultiplier = 1.0;
        if (ServerConfig.MOD_CONFIG_SPEC.isLoaded()) {
            chanceMultiplier = ServerConfig.DRAGON_EGG_SPAWN_CHANCE;
        }
        LootPool.Builder lootPoolBuilder = LootPool.lootPool().when(LootItemRandomChanceCondition.randomChance((float)((float)((double)entry.chance() * chanceMultiplier)))).add((LootPoolEntryContainer.Builder)lootItemBuilder).name(breed.getId() + "-egg");
        return lootPoolBuilder.build();
    }

    public static LootPool injectArmorLoot(DragonArmor armor, IDragonBreed.LootTableEntry entry) {
        LootPoolSingletonContainer.Builder lootItemBuilder = LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.DRAGON_ARMOR.get())).apply((LootItemFunction.Builder)SetComponentsFunction.setComponent(ModComponents.ARMOR_TYPE.get(), (Object)armor.getId()));
        LootPool.Builder lootPoolBuilder = LootPool.lootPool().when(LootItemRandomChanceCondition.randomChance((float)entry.chance())).add((LootPoolEntryContainer.Builder)lootItemBuilder).name(armor.getId() + "-armor");
        return lootPoolBuilder.build();
    }

    @SubscribeEvent
    public static void onLootLoad(LootTableLoadEvent evt) {
        for (IDragonBreed breed : DragonBreedsRegistry.getDragonBreeds()) {
            if (breed.isHybrid()) continue;
            for (IDragonBreed.LootTableEntry entry : breed.getLootTable()) {
                if (evt == null || !evt.getName().equals((Object)entry.table())) continue;
                LootPool pool = LootTableInject.injectEggLoot(breed, entry, null);
                if (evt.getTable().getPool(pool.getName()) != null) {
                    evt.getTable().removePool(pool.getName());
                }
                evt.getTable().addPool(pool);
                for (IDragonBreed.Variant variant : breed.getVariants()) {
                    LootPool vPool = LootTableInject.injectEggLoot(breed, entry, variant);
                    if (evt.getTable().getPool(vPool.getName()) != null) {
                        evt.getTable().removePool(vPool.getName());
                    }
                    evt.getTable().addPool(vPool);
                }
            }
        }
        for (DragonArmor armor : DragonArmorRegistry.getDragonArmors()) {
            for (IDragonBreed.LootTableEntry entry : armor.getLootTable()) {
                if (evt == null || !evt.getName().equals((Object)entry.table())) continue;
                LootPool armorPool = LootTableInject.injectArmorLoot(armor, entry);
                if (evt.getTable().getPool(armorPool.getName()) != null) {
                    evt.getTable().removePool(armorPool.getName());
                }
                evt.getTable().addPool(armorPool);
            }
        }
    }
}

