/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.server.entity.dragon;

import dmr.DragonMounts.client.handlers.KeyInputHandler;
import dmr.DragonMounts.common.capability.DragonOwnerCapability;
import dmr.DragonMounts.server.entity.DragonConstants;
import dmr.DragonMounts.server.entity.dragon.DragonOwnershipComponent;
import dmr.DragonMounts.util.PlayerStateUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

abstract class DragonMountingComponent
extends DragonOwnershipComponent {
    protected DragonMountingComponent(EntityType<? extends TamableAnimal> entityType, Level level) {
        super(entityType, level);
    }

    public void positionRider(Entity passenger, Entity.MoveFunction callback) {
        LivingEntity riddenByEntity = this.getControllingPassenger();
        if (riddenByEntity != null) {
            boolean customRidingPos = false;
            if (!customRidingPos) {
                Vec3 vec3 = this.getPassengerRidingPosition(passenger);
                Vec3 vec31 = passenger.getVehicleAttachmentPoint((Entity)this);
                Vec3 riderPos = new Vec3(vec3.x - vec31.x, vec3.y - vec31.y, vec3.z - vec31.z);
                callback.accept(passenger, riderPos.x, riderPos.y, riderPos.z);
            }
            if (this.getFirstPassenger() instanceof LivingEntity) {
                riddenByEntity.xRotO = riddenByEntity.getXRot();
                riddenByEntity.yRotO = riddenByEntity.getYRot();
                riddenByEntity.yBodyRot = this.yBodyRot;
            }
        }
    }

    protected Vec3 getRiddenInput(Player driver, Vec3 move) {
        double moveSideways = move.x;
        double moveY = 0.0;
        double moveForward = Math.min(Math.abs(driver.zza) + Math.abs(driver.xxa), 1.0f);
        DragonOwnerCapability handler = PlayerStateUtils.getHandler(driver);
        if (this.isFlying()) {
            double d = moveForward = moveForward > 0.0 ? moveForward : 0.0;
            if (moveForward > 0.0 && handler.cameraFlight) {
                moveY = -((double)driver.getXRot() * (Math.PI / 180) * 0.5);
            }
            if (driver.jumping) {
                moveY += 0.5;
            }
            if (driver.isShiftKeyDown()) {
                moveY += -0.5;
            } else if (this.level().isClientSide() && KeyInputHandler.DESCEND_KEY.isDown()) {
                moveY -= 0.5;
            }
        } else if (this.isInFluidType()) {
            double d = moveForward = moveForward > 0.0 ? moveForward : 0.0;
            if (moveForward > 0.0 && handler.cameraFlight) {
                moveY = (double)(-driver.getXRot()) * (Math.PI / 180) * 2.0;
            }
            if (driver.jumping) {
                moveY += 2.0;
            }
            if (driver.isShiftKeyDown()) {
                moveY += -2.0;
            } else if (this.level().isClientSide() && KeyInputHandler.DESCEND_KEY.isDown()) {
                moveY += -0.5;
            }
        }
        float f = this.isShiftKeyDown() ? 0.3f : 1.0f;
        Vec3 movement = new Vec3(moveSideways * (double)f, moveY, moveForward * (double)f);
        return this.maybeBackOffFromEdge(movement, MoverType.SELF);
    }

    public boolean canSprint() {
        return true;
    }

    protected boolean isAboveGround() {
        return this.onGround() || this.fallDistance < this.maxUpStep() && !this.level().noCollision((Entity)this, this.getBoundingBox().move(0.0, (double)(this.fallDistance - this.maxUpStep()), 0.0));
    }

    public Vec3 maybeBackOffFromEdge(Vec3 pVec, MoverType pMover) {
        if (pVec.y <= 0.0 && this.isShiftKeyDown() && this.isAboveGround()) {
            double d0 = pVec.x;
            double d1 = pVec.z;
            while (d0 != 0.0 && this.level.noCollision((Entity)this, this.getBoundingBox().move(d0, (double)(-this.maxUpStep()), 0.0))) {
                if (d0 < 0.05 && d0 >= -0.05) {
                    d0 = 0.0;
                    continue;
                }
                if (d0 > 0.0) {
                    d0 -= 0.05;
                    continue;
                }
                d0 += 0.05;
            }
            while (d1 != 0.0 && this.level.noCollision((Entity)this, this.getBoundingBox().move(0.0, (double)(-this.maxUpStep()), d1))) {
                if (d1 < 0.05 && d1 >= -0.05) {
                    d1 = 0.0;
                    continue;
                }
                if (d1 > 0.0) {
                    d1 -= 0.05;
                    continue;
                }
                d1 += 0.05;
            }
            while (d0 != 0.0 && d1 != 0.0 && this.level.noCollision((Entity)this, this.getBoundingBox().move(d0, (double)(-this.maxUpStep()), d1))) {
                d0 = d0 < 0.05 && d0 >= -0.05 ? 0.0 : (d0 > 0.0 ? (d0 -= 0.05) : (d0 += 0.05));
                if (d1 < 0.05 && d1 >= -0.05) {
                    d1 = 0.0;
                    continue;
                }
                if (d1 > 0.0) {
                    d1 -= 0.05;
                    continue;
                }
                d1 += 0.05;
            }
            pVec = new Vec3(d0, pVec.y, d1);
        }
        return pVec;
    }

    protected void tickRidden(Player driver, Vec3 move) {
        super.tickRidden(driver, move);
        float yaw = driver.yHeadRot;
        if (move.z > 0.0) {
            yaw += (float)Mth.atan2((double)driver.zza, (double)driver.xxa) * 57.295776f - 90.0f;
        }
        this.yHeadRot = driver.yHeadRot;
        this.setXRot(driver.getXRot() * 0.68f);
        this.setYRot(Mth.rotateIfNecessary((float)yaw, (float)this.getYRot(), (float)8.0f));
        if (this.isControlledByLocalInstance() && driver.jumping) {
            if (!this.isFlying() && this.canFly()) {
                this.liftOff();
            } else if (this.onGround() && !this.canFly()) {
                this.jumpFromGround();
            }
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.getPose() == Pose.STANDING) {
            if (this.isShiftKeyDown()) {
                this.setPose(Pose.CROUCHING);
            }
        } else if (this.getPose() == Pose.CROUCHING && !this.isShiftKeyDown()) {
            this.setPose(Pose.STANDING);
        }
    }

    @Override
    public void baseTick() {
        super.baseTick();
        if (this.isControlledByLocalInstance() && this.getControllingPassenger() != null) {
            if (this.isRandomlySitting()) {
                this.setRandomlySitting(false);
            }
            this.setSprinting(this.getControllingPassenger().isSprinting());
        }
    }

    public void setRidingPlayer(Player player) {
        player.setYRot(this.getYRot());
        player.setXRot(this.getXRot());
        player.startRiding((Entity)this);
    }

    public Vec3 getDismountLocationForPassenger(LivingEntity pLivingEntity) {
        Vec3 vec3 = DragonMountingComponent.getCollisionHorizontalEscapeVector((double)this.getBbWidth(), (double)pLivingEntity.getBbWidth(), (float)(this.getYRot() + (pLivingEntity.getMainArm() == HumanoidArm.RIGHT ? 90.0f : -90.0f)));
        Vec3 vec31 = this.getDismountLocationInDirection(vec3, pLivingEntity);
        if (vec31 != null) {
            return vec31;
        }
        Vec3 vec32 = DragonMountingComponent.getCollisionHorizontalEscapeVector((double)this.getBbWidth(), (double)pLivingEntity.getBbWidth(), (float)(this.getYRot() + (pLivingEntity.getMainArm() == HumanoidArm.LEFT ? 90.0f : -90.0f)));
        Vec3 vec33 = this.getDismountLocationInDirection(vec32, pLivingEntity);
        return vec33 != null ? vec33 : this.position();
    }

    public Vec3 getDismountLocationInDirection(Vec3 pDirection, LivingEntity pPassenger) {
        double d0 = this.getX() + pDirection.x;
        double d1 = this.getBoundingBox().minY;
        double d2 = this.getZ() + pDirection.z;
        BlockPos.MutableBlockPos blockpos_mutableblockpos = new BlockPos.MutableBlockPos();
        block0: for (Pose pose : pPassenger.getDismountPoses()) {
            blockpos_mutableblockpos.set(d0, d1, d2);
            double d3 = this.getBoundingBox().maxY + 0.75;
            do {
                Vec3 vec3;
                AABB aabb;
                double d4 = this.level.getBlockFloorHeight((BlockPos)blockpos_mutableblockpos);
                if ((double)blockpos_mutableblockpos.getY() + d4 > d3) continue block0;
                if (DismountHelper.isBlockFloorValid((double)d4) && DismountHelper.canDismountTo((CollisionGetter)this.level, (LivingEntity)pPassenger, (AABB)(aabb = pPassenger.getLocalBoundsForPose(pose)).move(vec3 = new Vec3(d0, (double)blockpos_mutableblockpos.getY() + d4, d2)))) {
                    pPassenger.setPose(pose);
                    return vec3;
                }
                blockpos_mutableblockpos.move(Direction.UP);
            } while ((double)blockpos_mutableblockpos.getY() < d3);
        }
        return null;
    }

    public boolean isShiftKeyDown() {
        Player player;
        LivingEntity livingEntity;
        if (this.getControllingPassenger() != null && this.getControllingPassenger().isShiftKeyDown()) {
            return true;
        }
        if (this.getControllingPassenger() == null && this.getOwner() != null && !this.hasWanderTarget() && !this.isOrderedToSit() && this.getPose() != Pose.SLEEPING && (livingEntity = this.getOwner()) instanceof Player && (double)this.distanceTo((Entity)(player = (Player)livingEntity)) <= DragonConstants.BASE_FOLLOW_RANGE) {
            return player.isShiftKeyDown();
        }
        return super.isShiftKeyDown();
    }

    public LivingEntity getControllingPassenger() {
        LivingEntity driver;
        Entity entity = this.getFirstPassenger();
        return entity instanceof LivingEntity && this.isOwnedBy(driver = (LivingEntity)entity) ? driver : null;
    }
}

