/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.server.entity.dragon;

import dmr.DragonMounts.registry.ModSounds;
import dmr.DragonMounts.server.entity.dragon.DragonMountingComponent;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

abstract class DragonAudioComponent
extends DragonMountingComponent {
    protected DragonAudioComponent(EntityType<? extends TamableAnimal> entityType, Level level) {
        super(entityType, level);
    }

    public SoundEvent getAmbientSound() {
        return this.getBreed().getAmbientSound() != null ? this.getBreed().getAmbientSound() : ModSounds.DRAGON_AMBIENT_SOUND.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return SoundEvents.ENDER_DRAGON_HURT;
    }

    public SoundEvent getDeathSound() {
        return ModSounds.DRAGON_DEATH_SOUND.get();
    }

    public SoundEvent getEatingSound(ItemStack itemStackIn) {
        return SoundEvents.GENERIC_EAT;
    }

    public SoundEvent getAttackSound() {
        return SoundEvents.GENERIC_EAT;
    }

    public SoundEvent getStepSound() {
        return ModSounds.DRAGON_STEP_SOUND.get();
    }

    public SoundEvent getWingsSound() {
        return SoundEvents.ENDER_DRAGON_FLAP;
    }

    protected void playStepSound(BlockPos entityPos, BlockState state) {
        if (this.isInWater()) {
            return;
        }
        if (this.isHatchling()) {
            super.playStepSound(entityPos, state);
            return;
        }
        this.playSound(this.getStepSound(), 0.15f, 1.0f);
    }

    public void onFlap() {
        if (this.level().isClientSide && !this.isSilent()) {
            this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), this.getWingsSound(), this.getSoundSource(), 2.0f, 0.8f + this.getRandom().nextFloat() * 0.3f, false);
        }
    }
}

