/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.server.entity;

import com.mojang.serialization.Dynamic;
import dmr.DragonMounts.DMR;
import dmr.DragonMounts.common.capability.DragonOwnerCapability;
import dmr.DragonMounts.common.handlers.DragonWhistleHandler;
import dmr.DragonMounts.config.ServerConfig;
import dmr.DragonMounts.registry.ModCriterionTriggers;
import dmr.DragonMounts.server.ai.DragonAI;
import dmr.DragonMounts.server.entity.dragon.AbstractDragonEntity;
import dmr.DragonMounts.server.worlddata.DragonWorldData;
import dmr.DragonMounts.server.worlddata.DragonWorldDataManager;
import dmr.DragonMounts.util.PlayerStateUtils;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SaddleItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.NeoForgeMod;
import org.jetbrains.annotations.Nullable;

public class TameableDragonEntity
extends AbstractDragonEntity {
    public TameableDragonEntity(EntityType<? extends TamableAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    protected Brain<?> makeBrain(Dynamic<?> dynamic) {
        return DragonAI.makeBrain((Brain<TameableDragonEntity>)this.brainProvider().makeBrain(dynamic));
    }

    protected void customServerAiStep() {
        this.level().getProfiler().push("dragonBrain");
        this.getBrain().tick((ServerLevel)this.level, (LivingEntity)this);
        this.level().getProfiler().pop();
        this.level().getProfiler().push("dragonActivityUpdate");
        DragonAI.selectMostAppropriateActivity(this);
        this.level().getProfiler().pop();
        super.customServerAiStep();
    }

    public Brain<TameableDragonEntity> getBrain() {
        return super.getBrain();
    }

    protected Brain.Provider<?> brainProvider() {
        return DragonAI.brainProvider();
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return (this.wasHatched() || this.tickCount > 2400 || this.isNaturalSpawn()) && !this.isTame() && distanceToClosestPlayer > (double)Mth.sqrt((float)32.0f) && !this.hasCustomName();
    }

    protected Component getTypeName() {
        if (this.hasVariant()) {
            return Component.translatable((String)("dmr.dragon_breed." + this.getBreed().getId() + "$" + this.getVariantId()));
        }
        return this.getBreed().getName();
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        InteractionResult stackResult = stack.interactLivingEntity(player, (LivingEntity)this, hand);
        if (stackResult.consumesAction()) {
            return stackResult;
        }
        if (!this.isTame()) {
            if (this.isServer() && this.isTamingItem(stack)) {
                stack.shrink(1);
                boolean shouldTame = this.getRandom().nextInt(5) == 0;
                this.tamedFor(player, shouldTame);
                if (shouldTame && player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    ModCriterionTriggers.TAME_DRAGON.get().trigger(serverPlayer);
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        if (this.getHealthRelative() < 1.0 && this.getHealth() < this.getMaxHealth() - 1.0f && this.isFoodItem(stack)) {
            this.heal(stack.getItem().getFoodProperties(stack, (LivingEntity)this).nutrition());
            this.playSound(this.getEatingSound(stack), 0.7f, 1.0f);
            stack.shrink(1);
            return InteractionResult.sidedSuccess((boolean)this.level.isClientSide);
        }
        if (this.isTamedFor(player) && this.isSaddleable() && !this.isSaddled() && stack.getItem() instanceof SaddleItem) {
            if (!player.getAbilities().instabuild) {
                stack.shrink(1);
            }
            this.equipSaddle(stack, this.getSoundSource());
            this.updateContainerEquipment();
            return InteractionResult.sidedSuccess((boolean)this.level.isClientSide);
        }
        if (this.isTamedFor(player) && this.isArmor(stack)) {
            this.equipArmor(player, stack);
            this.updateContainerEquipment();
            return InteractionResult.sidedSuccess((boolean)this.level.isClientSide);
        }
        if (this.isTamedFor(player) && !this.hasChest() && stack.is(Items.CHEST)) {
            this.getInventory().setItem(2, stack.copyWithCount(1));
            if (!player.getAbilities().instabuild) {
                stack.shrink(1);
            }
            this.updateContainerEquipment();
            return InteractionResult.sidedSuccess((boolean)this.level.isClientSide);
        }
        if (this.isTamedFor(player) && player.isSecondaryUseActive()) {
            if (!this.level.isClientSide) {
                this.openCustomInventoryScreen(player);
            }
            return InteractionResult.sidedSuccess((boolean)this.level.isClientSide);
        }
        if (this.isTamedFor(player) && this.isSaddled() && !this.isHatchling() && !this.isFood(stack)) {
            if (this.isServer()) {
                this.setRidingPlayer(player);
                this.navigation.stop();
            }
            this.setTarget(null);
            this.setWanderTarget(Optional.empty());
            this.stopSitting();
            this.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
            this.updateOwnerData();
            return InteractionResult.sidedSuccess((boolean)this.level.isClientSide);
        }
        return super.mobInteract(player, hand);
    }

    @Override
    public void baseTick() {
        super.baseTick();
        if (!this.level.isClientSide && this.isAlive() && this.tickCount % 20 == 0) {
            this.heal((float)ServerConfig.HEALTH_REGEN);
        }
        if (this.getDragonInventory() != null && this.getDragonInventory().isDirty()) {
            this.updateContainerEquipment();
        }
    }

    protected void sendDebugPackets() {
        super.sendDebugPackets();
        DebugPackets.sendEntityBrain((LivingEntity)this);
    }

    @Override
    public void onSyncedDataUpdated(EntityDataAccessor<?> data) {
        if (DATA_FLAGS_ID.equals(data)) {
            this.refreshDimensions();
        } else {
            super.onSyncedDataUpdated((EntityDataAccessor)data);
        }
    }

    @Nullable
    public Entity changeDimension(DimensionTransition transition) {
        Entity entity = super.changeDimension(transition);
        if (entity instanceof TameableDragonEntity) {
            TameableDragonEntity dragon = (TameableDragonEntity)entity;
            LivingEntity owner = this.getOwner();
            DMR.LOGGER.debug("Changing dimension of dragon {} to {}", (Object)this.getDragonUUID(), (Object)transition.newLevel().dimension().location());
            if (owner instanceof Player) {
                Player player = (Player)owner;
                DragonOwnerCapability handler = PlayerStateUtils.getHandler(player);
                int index = DragonWhistleHandler.getDragonSummonIndex(player, this.getDragonUUID());
                handler.setDragonInstance(index, new DragonWhistleHandler.DragonInstance(dragon));
                if (handler.lastSummons.get(index) != null && handler.lastSummons.get(index).equals(this.getUUID())) {
                    handler.lastSummons.put(index, entity.getUUID());
                }
            }
            DragonWorldData worldData1 = DragonWorldDataManager.getInstance(this.level);
            DragonWorldData worldData2 = DragonWorldDataManager.getInstance((Level)transition.newLevel());
            worldData2.dragonInventories.put(this.getDragonUUID(), worldData1.dragonInventories.get(this.getDragonUUID()));
            worldData1.dragonInventories.remove(this.getDragonUUID());
            return dragon;
        }
        return null;
    }

    public void travel(Vec3 travelVector) {
        if (!this.isInWater() || !this.canDrownInFluidType(Fluids.WATER.getFluidType())) {
            super.travel(travelVector);
            return;
        }
        double y0 = this.getY();
        float waterFriction = this.isSprinting() ? 0.7f : 0.5f;
        float inWaterSpeedModifier = (float)this.getAttributeValue(NeoForgeMod.SWIM_SPEED);
        this.moveRelative(inWaterSpeedModifier, travelVector);
        this.move(MoverType.SELF, this.getDeltaMovement());
        Vec3 deltaVector = this.getDeltaMovement();
        if (this.horizontalCollision && this.onClimbable()) {
            deltaVector = new Vec3(deltaVector.x, 0.2, deltaVector.z);
        }
        Vec3 waterDragVector = new Vec3(deltaVector.x * (double)waterFriction * 0.6, deltaVector.y * (double)this.getWaterSlowDown(), deltaVector.z * (double)waterFriction * 0.6);
        this.setDeltaMovement(waterDragVector);
        Vec3 nextDeltaVector = this.getDeltaMovement();
        if (this.horizontalCollision && this.isFree(nextDeltaVector.x, nextDeltaVector.y + 0.6 - this.getY() + y0, nextDeltaVector.z)) {
            this.setDeltaMovement(nextDeltaVector.x, 0.3, nextDeltaVector.z);
        }
    }
}

