/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.server.blockentities;

import dmr.DragonMounts.network.packets.BlankEggSyncPacket;
import dmr.DragonMounts.registry.ModBlockEntities;
import dmr.DragonMounts.registry.ModBlocks;
import dmr.DragonMounts.server.blockentities.DMREggBlockEntity;
import dmr.DragonMounts.types.dragonBreeds.IDragonBreed;
import dmr.DragonMounts.util.BreedingUtils;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.PacketDistributor;

public class DMRBlankEggBlockEntity
extends BlockEntity {
    private String targetBreedId;
    private int changeTime = 0;
    public float renderProgress = 0.0f;
    public static final int MAX_RENDER_PROGRESS = 60;
    public int tickCount = 0;

    public DMRBlankEggBlockEntity(BlockPos pos, BlockState blockState) {
        super(ModBlockEntities.BLANK_EGG_BLOCK_ENTITY.get(), pos, blockState);
    }

    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider registries) {
        super.saveAdditional(pTag, registries);
        if (this.targetBreedId != null) {
            pTag.putString("targetBreedId", this.targetBreedId);
        }
        pTag.putInt("changeTime", this.changeTime);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (tag.contains("targetBreedId")) {
            this.targetBreedId = tag.getString("targetBreedId");
        }
        this.changeTime = tag.getInt("changeTime");
    }

    public void tick(Level level, BlockPos pos, BlockState state) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ++this.tickCount;
        if (this.tickCount % 20 == 0) {
            IDragonBreed targetBreed = BreedingUtils.getHabitatBreedOutcome(serverLevel, pos);
            if (targetBreed == null) {
                if (this.targetBreedId != null && !this.targetBreedId.isEmpty() && this.changeTime > 0) {
                    --this.changeTime;
                } else if (this.targetBreedId != null && !this.targetBreedId.isEmpty()) {
                    this.targetBreedId = null;
                    this.changeTime = 0;
                }
            } else if (this.targetBreedId == null || this.targetBreedId.isEmpty()) {
                this.targetBreedId = targetBreed.getId();
                this.changeTime = 0;
            } else if (this.targetBreedId.equals(targetBreed.getId()) && this.changeTime < 60) {
                ++this.changeTime;
            } else if (!this.targetBreedId.equals(targetBreed.getId()) && this.changeTime > 0) {
                --this.changeTime;
            } else if (!this.targetBreedId.equals(targetBreed.getId()) && this.changeTime <= 0) {
                this.targetBreedId = targetBreed.getId();
            }
            PacketDistributor.sendToPlayersNear((ServerLevel)serverLevel, null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (double)64.0, (CustomPacketPayload)new BlankEggSyncPacket(pos, this.targetBreedId == null ? "" : this.targetBreedId, this.getChangeTime()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            if (this.targetBreedId != null && !this.targetBreedId.isEmpty() && targetBreed != null && this.targetBreedId.equals(targetBreed.getId()) && this.changeTime >= 60) {
                this.changeTime = 0;
                this.targetBreedId = null;
                level.setBlockAndUpdate(pos, ModBlocks.DRAGON_EGG_BLOCK.get().defaultBlockState());
                BlockEntity blockEntity = level.getBlockEntity(pos);
                if (blockEntity instanceof DMREggBlockEntity) {
                    DMREggBlockEntity eggBlockEntity = (DMREggBlockEntity)blockEntity;
                    eggBlockEntity.setBreed(targetBreed);
                }
            }
        }
    }

    @Generated
    public String getTargetBreedId() {
        return this.targetBreedId;
    }

    @Generated
    public void setTargetBreedId(String targetBreedId) {
        this.targetBreedId = targetBreedId;
    }

    @Generated
    public int getChangeTime() {
        return this.changeTime;
    }

    @Generated
    public void setChangeTime(int changeTime) {
        this.changeTime = changeTime;
    }
}

