/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.server.ai.navigation;

import dmr.DragonMounts.server.ai.navigation.DragonNodeEvaluator;
import dmr.DragonMounts.server.entity.TameableDragonEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.Nullable;

public class DragonPathNavigation
extends FlyingPathNavigation {
    protected final TameableDragonEntity dragon;
    private int lastPathCreationDelta = 0;
    private static final int TICKS_BETWEEN_PATH_CREATIONS = 5;
    private DragonNodeEvaluator dragonNodeEvaluator;

    public DragonPathNavigation(TameableDragonEntity dragon, Level level) {
        super((Mob)dragon, level);
        this.dragon = dragon;
        this.setMaxVisitedNodesMultiplier(5.0f);
    }

    protected PathFinder createPathFinder(int pMaxVisitedNodes) {
        this.dragonNodeEvaluator = new DragonNodeEvaluator(this.mob);
        this.nodeEvaluator = this.dragonNodeEvaluator;
        return new PathFinder(this.nodeEvaluator, pMaxVisitedNodes);
    }

    public boolean canCutCorner(PathType pathType) {
        return super.canCutCorner(pathType) || pathType == PathType.WATER;
    }

    protected Vec3 getTempMobPos() {
        return this.mob.position().subtract(0.0, 0.0, 0.0);
    }

    protected double getGroundY(Vec3 p_217794_) {
        return this.dragonNodeEvaluator.allowSwimming ? p_217794_.y : super.getGroundY(p_217794_);
    }

    public void tick() {
        super.tick();
        ++this.lastPathCreationDelta;
    }

    @Nullable
    public Path createPath(BlockPos pos, int accuracy) {
        if (this.lastPathCreationDelta < 5) {
            return null;
        }
        this.lastPathCreationDelta = 0;
        boolean bl = this.dragonNodeEvaluator.allowSwimming = this.dragon.getBreed() != null && this.dragon.getBreed().getImmunities().contains("drown") && this.dragon.level.getFluidState(pos).is(Tags.Fluids.WATER);
        if (this.dragon.isFlying()) {
            return this.createPathWithFlyingAllowed(pos, accuracy);
        }
        this.dragonNodeEvaluator.allowFlying = false;
        Path path = super.createPath(pos, accuracy);
        if (path != null && path.canReach() && path.getNodeCount() > 1) {
            return path;
        }
        int dif = this.mob.blockPosition().distManhattan((Vec3i)pos);
        float jumpHeight = Math.max(1.125f, this.mob.maxUpStep());
        if ((float)Mth.abs((int)dif) < jumpHeight) {
            return path;
        }
        return this.createPathWithFlyingAllowed(pos, accuracy);
    }

    private Path createPathWithFlyingAllowed(BlockPos pos, int accuracy) {
        this.dragonNodeEvaluator.allowFlying = true;
        Path path = super.createPath(pos, accuracy);
        if (path == null) {
            return path;
        }
        return this.streamlinePath(path, pos);
    }

    private Path streamlinePath(Path path, BlockPos pos) {
        int closestNodeDist = -1;
        int skipToNodeIndex = 0;
        int i = 0;
        while (i < path.getNodeCount()) {
            BlockPos nodePos = path.getNodePos(i);
            int distFromDragon = this.mob.blockPosition().distManhattan((Vec3i)nodePos);
            int distFromPlayer = pos.distManhattan((Vec3i)nodePos);
            if (distFromPlayer >= closestNodeDist && distFromPlayer <= distFromDragon) break;
            closestNodeDist = distFromPlayer;
            skipToNodeIndex = i++;
        }
        path.setNextNodeIndex(skipToNodeIndex);
        return path;
    }

    protected boolean canUpdatePath() {
        return true;
    }

    protected boolean canMoveDirectly(Vec3 p_217796_, Vec3 p_217797_) {
        return this.dragonNodeEvaluator.allowSwimming && this.mob.isInLiquid() && DragonPathNavigation.isClearForMovementBetween((Mob)this.mob, (Vec3)p_217796_, (Vec3)p_217797_, (boolean)true);
    }

    public boolean isStableDestination(BlockPos pPos) {
        if (this.dragonNodeEvaluator.allowFlying) {
            return this.level.getBlockState(pPos).entityCanStandOn((BlockGetter)this.level, pPos, (Entity)this.mob);
        }
        if (this.dragonNodeEvaluator.allowSwimming) {
            return !this.level.getBlockState(pPos.below()).isAir();
        }
        BlockPos blockpos = pPos.below();
        return this.level.getBlockState(blockpos).isSolidRender((BlockGetter)this.level, blockpos);
    }
}

