/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.registry;

import dmr.DragonMounts.DMR;
import dmr.DragonMounts.server.items.BlankDragonEggItemBlock;
import dmr.DragonMounts.server.items.DragonArmorItem;
import dmr.DragonMounts.server.items.DragonEggItemBlock;
import dmr.DragonMounts.server.items.DragonSpawnEgg;
import dmr.DragonMounts.server.items.DragonWhistleItem;
import dmr.DragonMounts.server.items.dev.HabitatOutcomeCheck;
import dmr.DragonMounts.server.items.dev.InstantHatchItem;
import dmr.DragonMounts.server.items.dev.UseBreathAttackItem;
import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModItems {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((ResourceKey)Registries.ITEM, (String)"dmr");
    public static final Supplier<Item> DRAGON_SPAWN_EGG = ITEMS.register("dragon_spawn_egg", DragonSpawnEgg::new);
    public static final Supplier<Item> DRAGON_EGG_BLOCK_ITEM = ITEMS.register("dragon_egg", () -> new DragonEggItemBlock(new Item.Properties()));
    public static final Supplier<Item> BLANK_EGG_BLOCK_ITEM = ITEMS.register("blank_egg", () -> new BlankDragonEggItemBlock(new Item.Properties()));
    public static final Supplier<Item> DRAGON_ARMOR = ITEMS.register("dragon_armor", () -> new DragonArmorItem(new Item.Properties().stacksTo(1)));
    public static HashMap<Integer, Supplier<Item>> DRAGON_WHISTLES = ModItems.generateWhistles();

    private static HashMap<Integer, Supplier<Item>> generateWhistles() {
        HashMap<Integer, Supplier<Item>> map = new HashMap<Integer, Supplier<Item>>();
        for (DyeColor color : DyeColor.values()) {
            map.put(color.getId(), (Supplier<Item>)ITEMS.register("dragon_whistle." + color.getName(), () -> new DragonWhistleItem(new Item.Properties().stacksTo(1), color)));
        }
        return map;
    }

    public static void init() {
        if (DMR.DEBUG) {
            ITEMS.register("habitat_checker", HabitatOutcomeCheck::new);
            ITEMS.register("instant_hatch", InstantHatchItem::new);
            ITEMS.register("breath_attack", UseBreathAttackItem::new);
        }
    }
}

