/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.network.packets;

import dmr.DragonMounts.common.capability.DragonOwnerCapability;
import dmr.DragonMounts.network.AbstractMessage;
import dmr.DragonMounts.registry.ModCapabilities;
import lombok.Generated;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class DragonRespawnDelayPacket
extends AbstractMessage<DragonRespawnDelayPacket> {
    private static final StreamCodec<FriendlyByteBuf, DragonRespawnDelayPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, DragonRespawnDelayPacket::getIndex, (StreamCodec)ByteBufCodecs.INT, DragonRespawnDelayPacket::getDelay, DragonRespawnDelayPacket::new);
    private final int index;
    private final int delay;

    DragonRespawnDelayPacket() {
        this.index = -1;
        this.delay = -1;
    }

    public DragonRespawnDelayPacket(int index, int delay) {
        this.index = index;
        this.delay = delay;
    }

    @Override
    protected String getTypeName() {
        return "respawn_delay_sync";
    }

    @Override
    public StreamCodec<? super RegistryFriendlyByteBuf, DragonRespawnDelayPacket> streamCodec() {
        return STREAM_CODEC;
    }

    @Override
    public void handle(IPayloadContext context, Player player) {
        DragonOwnerCapability state = (DragonOwnerCapability)player.getData(ModCapabilities.PLAYER_CAPABILITY);
        state.respawnDelays.put(this.index, this.delay);
    }

    @Generated
    public int getIndex() {
        return this.index;
    }

    @Generated
    public int getDelay() {
        return this.delay;
    }
}

