/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.network.packets;

import dmr.DragonMounts.network.AbstractMessage;
import dmr.DragonMounts.server.blockentities.DMRBlankEggBlockEntity;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class BlankEggSyncPacket
extends AbstractMessage<BlankEggSyncPacket> {
    private static final StreamCodec<FriendlyByteBuf, BlankEggSyncPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, BlankEggSyncPacket::getPos, (StreamCodec)ByteBufCodecs.STRING_UTF8, BlankEggSyncPacket::getTargetBreed, (StreamCodec)ByteBufCodecs.INT, BlankEggSyncPacket::getChangeTime, BlankEggSyncPacket::new);
    private final BlockPos pos;
    private final String targetBreed;
    private final int changeTime;

    BlankEggSyncPacket() {
        this.pos = BlockPos.ZERO;
        this.targetBreed = "";
        this.changeTime = -1;
    }

    public BlankEggSyncPacket(BlockPos pos, String targetBreed, int changeTime) {
        this.pos = pos;
        this.targetBreed = targetBreed;
        this.changeTime = changeTime;
    }

    @Override
    protected String getTypeName() {
        return "blank_egg_sync";
    }

    @Override
    public StreamCodec<? super RegistryFriendlyByteBuf, BlankEggSyncPacket> streamCodec() {
        return STREAM_CODEC;
    }

    @Override
    public void handle(IPayloadContext supplier, Player player) {
        Level level = player.level();
        BlockEntity blockEntity = level.getBlockEntity(new BlockPos(this.pos.getX(), this.pos.getY(), this.pos.getZ()));
        if (blockEntity instanceof DMRBlankEggBlockEntity) {
            DMRBlankEggBlockEntity eggBlockEntity = (DMRBlankEggBlockEntity)blockEntity;
            eggBlockEntity.setTargetBreedId(this.targetBreed);
            eggBlockEntity.setChangeTime(this.changeTime);
        }
    }

    @Generated
    public BlockPos getPos() {
        return this.pos;
    }

    @Generated
    public String getTargetBreed() {
        return this.targetBreed;
    }

    @Generated
    public int getChangeTime() {
        return this.changeTime;
    }
}

