/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.data;

import com.google.common.collect.ImmutableMap;
import dmr.DragonMounts.DMR;
import dmr.DragonMounts.registry.ModBlocks;
import dmr.DragonMounts.registry.ModItems;
import dmr.DragonMounts.server.items.DragonWhistleItem;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;

public class DMRRecipeProvider
extends RecipeProvider {
    public DMRRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    protected void buildRecipes(RecipeOutput pRecipeOutput) {
        for (DyeColor color : DyeColor.values()) {
            ResourceLocation pId = DMR.id("dragon_whistle_item_" + color.getName());
            ImmutableMap keys = ImmutableMap.of((Object)Character.valueOf('I'), (Object)Ingredient.of((ItemLike[])new ItemLike[]{Items.IRON_INGOT}), (Object)Character.valueOf('#'), (Object)Ingredient.of((TagKey)ItemTags.PLANKS), (Object)Character.valueOf('D'), (Object)Ingredient.of((ItemLike[])new ItemLike[]{DyeItem.byColor((DyeColor)color)}));
            List<String> rows = List.of("I#I", "#D#", "I#I");
            ShapedRecipe shapedrecipe = new ShapedRecipe("dragon", RecipeBuilder.determineBookCategory((RecipeCategory)RecipeCategory.MISC), ShapedRecipePattern.of((Map)keys, rows), DragonWhistleItem.getWhistleItem(color), false);
            pRecipeOutput.accept(pId, (Recipe)shapedrecipe, null);
        }
        ShapelessRecipe shapelessrecipe = new ShapelessRecipe("dragon", RecipeBuilder.determineBookCategory((RecipeCategory)RecipeCategory.MISC), new ItemStack((ItemLike)ModItems.BLANK_EGG_BLOCK_ITEM.get()), NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModBlocks.DRAGON_EGG_BLOCK.get()})}));
        pRecipeOutput.accept(DMR.id("blank_egg"), (Recipe)shapelessrecipe, null);
    }
}

