/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.data;

import dmr.DragonMounts.DMR;
import dmr.DragonMounts.config.ClientConfig;
import dmr.DragonMounts.config.ServerConfig;
import dmr.DragonMounts.config.annotations.Config;
import java.lang.reflect.Field;
import java.util.HashSet;
import net.minecraft.data.PackOutput;
import net.neoforged.neoforge.common.data.LanguageProvider;

public class ConfigTranslationProvider
extends LanguageProvider {
    public ConfigTranslationProvider(PackOutput output) {
        super(output, "dmr", "en_us");
    }

    protected void addTranslations() {
        DMR.LOGGER.info("Generating config translations");
        this.processConfigClass(ServerConfig.class);
        this.processConfigClass(ClientConfig.class);
    }

    private void processConfigClass(Class<?> configClass) {
        Config configAnnotation;
        HashSet<String> categories = new HashSet<String>();
        for (Field field : configClass.getDeclaredFields()) {
            String[] categoryArray;
            configAnnotation = field.getAnnotation(Config.class);
            if (configAnnotation == null || (categoryArray = configAnnotation.category()).length <= 0) continue;
            categories.add(categoryArray[categoryArray.length - 1]);
        }
        for (String category : categories) {
            String categoryKey = "dmr.configuration." + category;
            this.add(categoryKey, this.formatCategoryName(category) + " Settings");
        }
        for (Field field : configClass.getDeclaredFields()) {
            configAnnotation = field.getAnnotation(Config.class);
            if (configAnnotation == null) continue;
            Object translationKey = configAnnotation.translation();
            if (((String)translationKey).isEmpty()) {
                String configType = configClass == ServerConfig.class ? "server" : "client";
                translationKey = "dmr.config." + configType + "." + configAnnotation.key();
            }
            this.add((String)translationKey, this.formatConfigName(configAnnotation.key()));
            CharSequence[] comments = configAnnotation.comment();
            if (comments.length <= 0) continue;
            this.add((String)translationKey + ".tooltip", String.join((CharSequence)"\n", comments));
        }
    }

    private String formatCategoryName(String category) {
        return this.formatConfigName(category);
    }

    private String formatConfigName(String key) {
        String[] words = key.split("_");
        StringBuilder result = new StringBuilder();
        for (String word : words) {
            if (word.isEmpty()) continue;
            result.append(Character.toUpperCase(word.charAt(0))).append(word.substring(1)).append(" ");
        }
        return result.toString().trim();
    }
}

