/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.config;

import dmr.DragonMounts.DMR;
import dmr.DragonMounts.config.ClientConfig;
import dmr.DragonMounts.config.ConfigProcessor;
import dmr.DragonMounts.config.ServerConfig;
import dmr.DragonMounts.network.packets.ConfigSyncPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

@EventBusSubscriber(modid="dmr", bus=EventBusSubscriber.Bus.MOD)
public class ConfigEventHandler {
    @SubscribeEvent
    public static void onConfigLoading(ModConfigEvent.Loading event) {
        if (event.getConfig().getSpec() == ServerConfig.MOD_CONFIG_SPEC) {
            DMR.LOGGER.info("Loading server config");
            ConfigProcessor.updateFieldValues(ServerConfig.class);
        } else if (event.getConfig().getSpec() == ClientConfig.MOD_CONFIG_SPEC) {
            DMR.LOGGER.info("Loading client config");
            ConfigProcessor.updateFieldValues(ClientConfig.class);
        }
    }

    @SubscribeEvent
    public static void onConfigReloading(ModConfigEvent.Reloading event) {
        if (event.getConfig().getSpec() == ServerConfig.MOD_CONFIG_SPEC) {
            DMR.LOGGER.info("Reloading server config");
            ConfigProcessor.updateFieldValues(ServerConfig.class);
            if (ServerLifecycleHooks.getCurrentServer() != null) {
                for (ServerPlayer player : ServerLifecycleHooks.getCurrentServer().getPlayerList().getPlayers()) {
                    ConfigSyncPacket.syncServerToClient((Player)player);
                }
            }
        } else if (event.getConfig().getSpec() == ClientConfig.MOD_CONFIG_SPEC) {
            DMR.LOGGER.info("Reloading client config");
            ConfigProcessor.updateFieldValues(ClientConfig.class);
            if (ServerConfig.MOD_CONFIG_SPEC.isLoaded()) {
                ConfigSyncPacket.syncClientToServer();
            }
        }
    }

    @EventBusSubscriber(modid="dmr")
    public static class _playerLoginEvent {
        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (event.getEntity() instanceof ServerPlayer) {
                DMR.LOGGER.info("Player logged in, syncing server configs");
                ConfigSyncPacket.syncServerToClient(event.getEntity());
            }
        }
    }
}

