/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.client.model;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import dmr.DragonMounts.client.model.DragonEggModel;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.neoforged.neoforge.client.model.geometry.IGeometryLoader;

public class DragonEggModelLoader
implements IGeometryLoader<DragonEggModel> {
    public static final DragonEggModelLoader INSTANCE = new DragonEggModelLoader();

    private DragonEggModelLoader() {
    }

    public DragonEggModel read(JsonObject jsonObject, JsonDeserializationContext deserializer) throws JsonParseException {
        ImmutableMap.Builder models = ImmutableMap.builder();
        String dir = "models/block/dragon_eggs";
        int length = "models/".length();
        int suffixLength = ".json".length();
        for (Map.Entry entry : Minecraft.getInstance().getResourceManager().listResources(dir, f -> f.getPath().endsWith(".json")).entrySet()) {
            ResourceLocation rl = (ResourceLocation)entry.getKey();
            String path = rl.getPath();
            path = path.substring(length, path.length() - suffixLength);
            String id = String.format("%s", path.substring("block/dragon_eggs/".length(), path.length() - "_dragon_egg".length()));
            try {
                BufferedReader reader = ((Resource)entry.getValue()).openAsReader();
                try {
                    models.put((Object)id, (Object)BlockModel.fromStream((Reader)reader));
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                }
            }
            catch (IOException e) {
                throw new JsonParseException((Throwable)e);
            }
        }
        return new DragonEggModel((ImmutableMap<String, BlockModel>)models.build());
    }
}

