/*
 * Decompiled with CFR 0.152.
 */
package net.myitian.roughlyenoughinputmethods.inputmethods;

import dev.architectury.platform.Platform;
import dev.architectury.utils.value.BooleanValue;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import me.shedaniel.rei.api.client.favorites.FavoriteMenuEntry;
import me.shedaniel.rei.api.client.search.method.CharacterUnpackingInputMethod;
import me.shedaniel.rei.api.client.search.method.InputMethod;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import net.minecraft.network.chat.Component;
import net.myitian.roughlyenoughinputmethods.RoughlyEnoughInputMethods;
import net.myitian.roughlyenoughinputmethods.UniHanManager;
import net.myitian.roughlyenoughinputmethods.inputmethods.UniHanInputMethod;

public class PinyinInputMethod
extends UniHanInputMethod
implements CharacterUnpackingInputMethod {
    protected static final Map<IntList, List<IntList>> incompleteInitialsFinals = new HashMap<IntList, List<IntList>>();
    protected static final Map<IntList, List<IntList>> vuFuzzyWithIncomplete = new HashMap<IntList, List<IntList>>();
    protected static final Map<IntList, IntList> vuFuzzy = new HashMap<IntList, IntList>();
    protected static final String[] finals = new String[]{"a", "e", "i", "o", "u", "v", "ai", "ei", "ao", "ou", "ia", "ie", "ua", "uo", "ve", "iao", "iou", "uai", "uei", "an", "ian", "uan", "van", "en", "in", "uen", "vn", "ang", "iang", "uang", "eng ", "ing", "ueng", "ong", "iong"};
    protected final Map<IntList, IntList> fuzzyMap = new LinkedHashMap<IntList, IntList>();
    protected final Int2ObjectMap<ToneEntry> toneMap = new Int2ObjectOpenHashMap();
    protected final Set<IntList> fuzzySet = new HashSet<IntList>();
    protected boolean allowIncompleteInitialsFinals = false;
    protected boolean allowVUFuzzy = false;

    public PinyinInputMethod(UniHanManager manager) {
        super(manager);
        this.addTone('\u0101', "a1");
        this.addTone('\u00e1', "a2");
        this.addTone('\u01ce', "a3");
        this.addTone('\u00e0', "a4");
        this.addTone('\u0113', "e1");
        this.addTone('\u00e9', "e2");
        this.addTone('\u011b', "e3");
        this.addTone('\u00e8', "e4");
        this.addTone('\u012b', "i1");
        this.addTone('\u00ed', "i2");
        this.addTone('\u01d0', "i3");
        this.addTone('\u00ec', "i4");
        this.addTone('\u014d', "o1");
        this.addTone('\u00f3', "o2");
        this.addTone('\u01d2', "o3");
        this.addTone('\u00f2', "o4");
        this.addTone('\u016b', "u1");
        this.addTone('\u00fa', "u2");
        this.addTone('\u01d4', "u3");
        this.addTone('\u00f9', "u4");
        this.addTone('\u01d6', "v1");
        this.addTone('\u01d8', "v2");
        this.addTone('\u01da', "v3");
        this.addTone('\u01dc', "v4");
        this.addFuzzy("z", "zh");
        this.addFuzzy("s", "sh");
        this.addFuzzy("c", "ch");
        this.addFuzzy("an", "ang");
        this.addFuzzy("en", "eng");
        this.addFuzzy("in", "ing");
        this.addFuzzy("ian", "iang");
        this.addFuzzy("uan", "uang");
        this.addFuzzy("n", "l");
        this.addFuzzy("r", "l");
        this.addFuzzy("h", "f");
        this.read();
    }

    private void addFuzzy(String original, String to) {
        this.fuzzyMap.put(IntList.of((int[])original.codePoints().toArray()), IntList.of((int[])to.codePoints().toArray()));
    }

    private void addTone(char c, String s) {
        this.toneMap.put((int)c, (Object)new ToneEntry(s.charAt(0), Character.digit(s.charAt(1), 10)));
    }

    protected void read() {
        Path path = Platform.getConfigFolder().resolve("roughlyenoughinputmethods/pinyin.properties");
        this.fuzzySet.clear();
        if (Files.exists(path, new LinkOption[0])) {
            try {
                Properties properties = new Properties();
                try (InputStream stream = Files.newInputStream(path, new OpenOption[0]);){
                    properties.load(stream);
                }
                this.allowIncompleteInitialsFinals = properties.getOrDefault((Object)"AllowIncompleteInitialsFinals", "false").equals("true");
                this.allowVUFuzzy = properties.getOrDefault((Object)"AllowVUFuzzy", "false").equals("true");
                for (IntList key : this.fuzzyMap.keySet()) {
                    if (!properties.getOrDefault((Object)("Fuzzy_" + new String(key.toIntArray(), 0, key.size())), "false").equals("true")) continue;
                    this.fuzzySet.add(key);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    Files.deleteIfExists(path);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
        this.write();
    }

    protected void write() {
        Path path = Platform.getConfigFolder().resolve("roughlyenoughinputmethods/pinyin.properties");
        Properties properties = new Properties();
        properties.put("AllowIncompleteInitialsFinals", this.allowIncompleteInitialsFinals ? "true" : "false");
        properties.put("AllowVUFuzzy", this.allowVUFuzzy ? "true" : "false");
        for (IntList key : this.fuzzyMap.keySet()) {
            if (!this.fuzzySet.contains(key)) continue;
            properties.put("Fuzzy_" + new String(key.toIntArray(), 0, key.size()), "true");
        }
        try (OutputStream stream = Files.newOutputStream(path, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);){
            properties.store(stream, "Pinyin Options");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Iterable<IntList> expendFilter(String filter) {
        return Collections.singletonList(IntList.of((int[])filter.codePoints().toArray()));
    }

    public List<CharacterUnpackingInputMethod.ExpendedChar> expendSourceChar(int codePoint) {
        List sequences = (List)this.dataMap.get(codePoint);
        if (sequences != null && !sequences.isEmpty()) {
            return sequences;
        }
        return List.of(new CharacterUnpackingInputMethod.ExpendedChar(List.of(IntList.of((int)codePoint))));
    }

    public List<InputMethod.Locale> getMatchingLocales() {
        return CollectionUtils.filterToList((Iterable)InputMethod.getAllLocales(), locale -> locale.code().startsWith("zh_"));
    }

    public Component getName() {
        return RoughlyEnoughInputMethods.createTranslatableText("text.roughlyenoughinputmethods.input.methods.pinyin", RoughlyEnoughInputMethods.createTranslatableText("text.rei.input.methods.pinyin"));
    }

    public Component getDescription() {
        return RoughlyEnoughInputMethods.createTranslatableText("text.rei.input.methods.pinyin.description");
    }

    public List<FavoriteMenuEntry> getOptionsMenuEntries() {
        ArrayList<FavoriteMenuEntry> innerEntries = new ArrayList<FavoriteMenuEntry>();
        innerEntries.add(FavoriteMenuEntry.createToggle((Component)RoughlyEnoughInputMethods.createTranslatableText("text.roughlyenoughinputmethods.input.methods.pinyin.allow-incomplete"), (BooleanValue)new BooleanValue(){

            public void accept(boolean b) {
                PinyinInputMethod.this.allowIncompleteInitialsFinals = b;
                PinyinInputMethod.this.write();
                PinyinInputMethod.this.dataMap.clear();
                PinyinInputMethod.this.load();
            }

            public boolean getAsBoolean() {
                return PinyinInputMethod.this.allowIncompleteInitialsFinals;
            }
        }));
        innerEntries.add(FavoriteMenuEntry.createToggle((Component)RoughlyEnoughInputMethods.createTranslatableText("text.roughlyenoughinputmethods.input.methods.pinyin.allow-vu-fuzzy"), (BooleanValue)new BooleanValue(){

            public void accept(boolean b) {
                PinyinInputMethod.this.allowVUFuzzy = b;
                PinyinInputMethod.this.write();
                PinyinInputMethod.this.dataMap.clear();
                PinyinInputMethod.this.load();
            }

            public boolean getAsBoolean() {
                return PinyinInputMethod.this.allowVUFuzzy;
            }
        }));
        this.fuzzyMap.forEach((from, to) -> innerEntries.add(FavoriteMenuEntry.createToggle((Component)Component.nullToEmpty((String)"%s -> %s".formatted(new String(from.toIntArray(), 0, from.size()), new String(to.toIntArray(), 0, to.size()))), (BooleanValue)new BooleanValue(){
            final /* synthetic */ IntList val$from;
            {
                this.val$from = intList;
            }

            public boolean getAsBoolean() {
                return PinyinInputMethod.this.fuzzySet.contains(this.val$from);
            }

            public void accept(boolean t) {
                if (t) {
                    PinyinInputMethod.this.fuzzySet.add(this.val$from);
                } else {
                    PinyinInputMethod.this.fuzzySet.remove(this.val$from);
                }
                PinyinInputMethod.this.write();
                PinyinInputMethod.this.dataMap.clear();
                PinyinInputMethod.this.load();
            }
        })));
        return List.of(FavoriteMenuEntry.createSubMenu((Component)RoughlyEnoughInputMethods.createTranslatableText("text.rei.input.methods.pinyin.fuzzy.matching"), innerEntries));
    }

    @Override
    protected List<CharacterUnpackingInputMethod.ExpendedChar> asExpendedChars(String string) {
        List[] codepoints = new List[3];
        int skip = 2;
        int tone = -1;
        char[] chars = string.toCharArray();
        if (chars[0] == 's' && chars[1] == 'h') {
            codepoints[0] = this.expendInitials("sh");
        } else if (chars[0] == 'c' && chars[1] == 'h') {
            codepoints[0] = this.expendInitials("ch");
        } else if (chars[0] == 'z' && chars[1] == 'h') {
            codepoints[0] = this.expendInitials("zh");
        } else {
            skip = 1;
            ToneEntry toneEntry = (ToneEntry)this.toneMap.get((int)chars[0]);
            if (toneEntry == null) {
                codepoints[0] = this.expendInitials("" + chars[0]);
            } else {
                codepoints[0] = this.expendInitials("" + (char)toneEntry.codepoint);
                tone = toneEntry.tone;
            }
        }
        StringBuilder builder = new StringBuilder();
        for (int i = skip; i < chars.length; ++i) {
            char c = chars[i];
            if (c == '\u00fc') {
                builder.append('v');
                continue;
            }
            ToneEntry toneEntry = (ToneEntry)this.toneMap.get((int)c);
            if (toneEntry == null) {
                builder.append(c);
                continue;
            }
            builder.append((char)toneEntry.codepoint);
            tone = toneEntry.tone;
        }
        int length = 2;
        if (builder.isEmpty()) {
            List<IntList>[] expendSingles = this.expendSingles(codepoints[0]);
            codepoints[0] = expendSingles[0];
            if (expendSingles.length > 1) {
                codepoints[1] = expendSingles[1];
            } else {
                length = 1;
            }
        } else {
            codepoints[1] = this.expendFinals(builder.toString());
        }
        if (tone != -1) {
            codepoints[++length - 1] = List.of(IntList.of((int)Character.forDigit(tone, 10)));
        }
        int combinations = 1;
        for (int i = 0; i < length; ++i) {
            combinations *= codepoints[i].size();
        }
        Object[] results = new List[combinations];
        int[] current = new int[length];
        block2: for (int i = 0; i < combinations; ++i) {
            int k;
            results[i] = new ArrayList();
            for (k = 0; k < length; ++k) {
                results[i].add((IntList)codepoints[k].get(current[k]));
            }
            for (k = 0; k < length; ++k) {
                if (current[k] + 1 < codepoints[k].size()) {
                    int n = k;
                    current[n] = current[n] + 1;
                    continue block2;
                }
                current[k] = 0;
            }
        }
        return CollectionUtils.map((Object[])results, CharacterUnpackingInputMethod.ExpendedChar::new);
    }

    protected List<IntList>[] expendSingles(List<IntList> codepoint) {
        return new List[]{codepoint};
    }

    protected List<IntList> expendSimple(String string) {
        Object l;
        IntList codepoints = IntList.of((int[])string.codePoints().toArray());
        ArrayList<IntList> result = new ArrayList<IntList>();
        result.add(codepoints);
        if (this.allowIncompleteInitialsFinals && (l = incompleteInitialsFinals.get(codepoints)) != null) {
            result.addAll((Collection<IntList>)l);
        }
        if (this.allowVUFuzzy && (l = vuFuzzy.get(codepoints)) != null) {
            result.add((IntList)l);
        }
        if (this.allowVUFuzzy && this.allowIncompleteInitialsFinals && (l = vuFuzzyWithIncomplete.get(codepoints)) != null) {
            result.addAll((Collection<IntList>)l);
        }
        if (this.fuzzySet.contains(codepoints)) {
            result.add(this.fuzzyMap.get(codepoints));
        }
        return result;
    }

    protected List<IntList> expendInitials(String string) {
        return this.expendSimple(string);
    }

    protected List<IntList> expendFinals(String string) {
        return this.expendSimple(string);
    }

    @Override
    public void load() {
        Int2ObjectOpenHashMap tmpMap = new Int2ObjectOpenHashMap();
        try {
            this.manager.load((arg_0, arg_1, arg_2) -> PinyinInputMethod.lambda$load$3((Int2ObjectMap)tmpMap, arg_0, arg_1, arg_2));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        tmpMap.forEach((codepoint, strSet) -> {
            List sequences = (List)this.dataMap.computeIfAbsent(codepoint, value -> new ArrayList());
            for (String string : strSet) {
                sequences.addAll(this.asExpendedChars(string));
            }
        });
    }

    private static /* synthetic */ void lambda$load$3(Int2ObjectMap tmpMap, int codepoint, String fieldKey, String data) {
        HashSet strSet = (HashSet)tmpMap.computeIfAbsent(codepoint, value -> new HashSet(4));
        block6 : switch (fieldKey) {
            case "kMandarin": {
                int end;
                int start = 0;
                while ((end = data.indexOf(32, start)) >= 0) {
                    strSet.add(data.substring(start, end));
                    start = end + 1;
                }
                strSet.add(data.substring(start));
                break;
            }
            case "kHanyuPinyin": {
                int end;
                int start = data.indexOf(58) + 1;
                while ((end = data.indexOf(44, start)) >= 0) {
                    strSet.add(data.substring(start, end));
                    start = end + 1;
                }
                strSet.add(data.substring(start));
                break;
            }
            case "kTGHZ2013": 
            case "kXHC1983": {
                int start = 0;
                while (true) {
                    int end;
                    if ((end = data.indexOf(32, start = data.indexOf(58, start) + 1)) < 0) {
                        strSet.add(data.substring(start));
                        break block6;
                    }
                    strSet.add(data.substring(start, end));
                    start = end + 1;
                }
            }
        }
    }

    static {
        incompleteInitialsFinals.put(IntList.of((int)122, (int)104), List.of(IntList.of((int)122)));
        incompleteInitialsFinals.put(IntList.of((int)115, (int)104), List.of(IntList.of((int)115)));
        incompleteInitialsFinals.put(IntList.of((int)99, (int)104), List.of(IntList.of((int)99)));
        for (String srcFinal : finals) {
            IntList src = IntList.of((int[])srcFinal.codePoints().toArray());
            ArrayList<IntList> inc = new ArrayList<IntList>();
            ArrayList<IntList> vuf = new ArrayList<IntList>();
            for (int i = srcFinal.length() - 1; i > 0; --i) {
                String f = srcFinal.substring(0, i);
                inc.add(IntList.of((int[])f.codePoints().toArray()));
                if (!f.contains("v")) continue;
                vuf.add(IntList.of((int[])f.replace('v', 'u').codePoints().toArray()));
            }
            incompleteInitialsFinals.put(src, inc);
            if (!vuf.isEmpty()) {
                vuFuzzyWithIncomplete.put(src, vuf);
            }
            if (!srcFinal.contains("v")) continue;
            vuFuzzy.put(src, IntList.of((int[])srcFinal.replace('v', 'u').codePoints().toArray()));
        }
    }

    protected static final class ToneEntry {
        public final int codepoint;
        public final int tone;

        public ToneEntry(int codepoint, int tone) {
            this.codepoint = codepoint;
            this.tone = tone;
        }
    }
}

