/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.platform.forge;

import dev.architectury.platform.Mod;
import dev.architectury.utils.Env;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.fml.loading.moddiscovery.ModFileInfo;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforgespi.language.IModFileInfo;
import net.neoforged.neoforgespi.language.IModInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlatformImpl {
    private static final Map<String, Mod> mods = new ConcurrentHashMap<String, Mod>();

    public static Path getGameFolder() {
        return FMLPaths.GAMEDIR.get();
    }

    public static Path getConfigFolder() {
        return FMLPaths.CONFIGDIR.get();
    }

    public static Path getModsFolder() {
        return FMLPaths.MODSDIR.get();
    }

    public static Env getEnvironment() {
        return Env.fromPlatform(PlatformImpl.getEnv());
    }

    public static Dist getEnv() {
        return FMLEnvironment.dist;
    }

    public static boolean isModLoaded(String id) {
        return ModList.get().isLoaded(id);
    }

    public static Mod getMod(String id) {
        return mods.computeIfAbsent(id, ModImpl::new);
    }

    public static Collection<Mod> getMods() {
        for (IModInfo mod : ModList.get().getMods()) {
            PlatformImpl.getMod(mod.getModId());
        }
        return mods.values();
    }

    public static Collection<String> getModIds() {
        return ModList.get().getMods().stream().map(IModInfo::getModId).collect(Collectors.toList());
    }

    public static boolean isDevelopmentEnvironment() {
        return !FMLLoader.isProduction();
    }

    private static class ModImpl
    implements Mod {
        private final ModContainer container;
        private final IModInfo info;

        public ModImpl(String id) {
            this.container = (ModContainer)ModList.get().getModContainerById(id).orElseThrow();
            this.info = ModList.get().getMods().stream().filter(modInfo -> Objects.equals(modInfo.getModId(), id)).findAny().orElseThrow();
        }

        @Override
        @NotNull
        public String getModId() {
            return this.info.getModId();
        }

        @Override
        @NotNull
        public String getVersion() {
            return this.info.getVersion().toString();
        }

        @Override
        @NotNull
        public String getName() {
            return this.info.getDisplayName();
        }

        @Override
        @NotNull
        public String getDescription() {
            return this.info.getDescription();
        }

        @Override
        public Optional<String> getLogoFile(int i) {
            return this.info.getLogoFile();
        }

        @Override
        public List<Path> getFilePaths() {
            return List.of(this.getFilePath());
        }

        @Override
        public Path getFilePath() {
            return this.info.getOwningFile().getFile().getSecureJar().getRootPath();
        }

        @Override
        public Optional<Path> findResource(String ... path) {
            return Optional.of(this.info.getOwningFile().getFile().findResource(path)).filter(x$0 -> Files.exists(x$0, new LinkOption[0]));
        }

        @Override
        public Collection<String> getAuthors() {
            Optional<String> optional = this.info.getConfig().getConfigElement(new String[]{"authors"}).map(String::valueOf);
            return optional.isPresent() ? Collections.singleton(optional.get()) : Collections.emptyList();
        }

        @Override
        @Nullable
        public Collection<String> getLicense() {
            return Collections.singleton(this.info.getOwningFile().getLicense());
        }

        @Override
        public Optional<String> getHomepage() {
            return this.info.getConfig().getConfigElement(new String[]{"displayURL"}).map(String::valueOf);
        }

        @Override
        public Optional<String> getSources() {
            return Optional.empty();
        }

        @Override
        public Optional<String> getIssueTracker() {
            IModFileInfo owningFile = this.info.getOwningFile();
            if (owningFile instanceof ModFileInfo) {
                ModFileInfo info = (ModFileInfo)owningFile;
                return Optional.ofNullable(info.getIssueURL()).map(URL::toString);
            }
            return Optional.empty();
        }

        @Override
        public void registerConfigurationScreen(Mod.ConfigurationScreenProvider configurationScreenProvider) {
            this.container.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)(container, screen) -> configurationScreenProvider.provide(screen)));
        }
    }
}

