/*
 * Decompiled with CFR 0.152.
 */
package com.iamkaf.liteminer.shapes;

import com.iamkaf.liteminer.Liteminer;
import com.iamkaf.liteminer.tags.TagHelper;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public interface Walker {
    public HashSet<BlockPos> walk(Level var1, Player var2, BlockPos var3);

    default public boolean shouldMine(Player player, Level level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        if (state.is(Blocks.AIR) || state.liquid()) {
            return false;
        }
        if (TagHelper.isBlockWhitelistEnabled() && !TagHelper.isWhitelistedBlock(state)) {
            return false;
        }
        if (state.getDestroySpeed((BlockGetter)level, pos) < 0.0f && !player.isCreative()) {
            return false;
        }
        ItemStack tool = player.getMainHandItem();
        if (!this.isValidTool(tool, state)) {
            return false;
        }
        return !TagHelper.isExcludedBlock(state);
    }

    default public boolean isValidTool(ItemStack tool, BlockState state) {
        if (TagHelper.isExcludedTool(tool)) {
            return false;
        }
        return (Boolean)Liteminer.CONFIG.requireCorrectToolEnabled.get() == false || !tool.isEmpty() && (tool.isCorrectToolForDrops(state) || TagHelper.isIncludedTool(tool));
    }
}

