/*
 * Decompiled with CFR 0.152.
 */
package com.iamkaf.liteminer.shapes;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.TallGrassBlock;

public class BlockFamily {
    private static final Map<Block, Set<Block>> BLOCK_MATCHES = new HashMap<Block, Set<Block>>();

    public static boolean matches(Block from, Block to) {
        if (to.equals(from)) {
            return true;
        }
        if (BLOCK_MATCHES.containsKey(to)) {
            Set<Block> blockMatches = BLOCK_MATCHES.get(to);
            return blockMatches.contains(from);
        }
        return !(!(from instanceof FlowerBlock) && !(from instanceof TallGrassBlock) && !(from instanceof DoublePlantBlock) || !(to instanceof FlowerBlock) && !(to instanceof TallGrassBlock) && !(to instanceof DoublePlantBlock));
    }

    private static void makeFamily(Block ... blocks) {
        for (Block block : blocks) {
            BLOCK_MATCHES.put(block, Set.of(blocks));
        }
    }

    static {
        BlockFamily.makeFamily(Blocks.RAW_IRON_BLOCK, Blocks.IRON_ORE, Blocks.DEEPSLATE_IRON_ORE);
        BlockFamily.makeFamily(Blocks.RAW_GOLD_BLOCK, Blocks.GOLD_ORE, Blocks.DEEPSLATE_GOLD_ORE);
        BlockFamily.makeFamily(Blocks.RAW_COPPER_BLOCK, Blocks.COPPER_ORE, Blocks.DEEPSLATE_COPPER_ORE);
    }
}

