/*
 * Decompiled with CFR 0.152.
 */
package com.iamkaf.liteminer.rendering;

import com.iamkaf.amber.api.aabb.BoundingBoxMerger;
import com.iamkaf.liteminer.LiteminerClient;
import com.iamkaf.liteminer.shapes.ShapelessWalker;
import com.iamkaf.liteminer.shapes.Walker;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.OptionalDouble;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Matrix4f;

public class BlockHighlightRenderer {
    private static final RenderType LINES_NORMAL = RenderType.create((String)"liteminer_lines_normal", (VertexFormat)DefaultVertexFormat.POSITION_COLOR, (VertexFormat.Mode)VertexFormat.Mode.DEBUG_LINES, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(new RenderStateShard.ShaderStateShard(GameRenderer::getPositionColorShader)).setLineState(new RenderStateShard.LineStateShard(OptionalDouble.empty())).setLayeringState(RenderStateShard.NO_LAYERING).setTransparencyState(RenderStateShard.TRANSLUCENT_TRANSPARENCY).setWriteMaskState(RenderStateShard.COLOR_WRITE).setCullState(RenderStateShard.CULL).createCompositeState(false));
    private static final RenderType LINES_TRANSPARENT = RenderType.create((String)"liteminer_lines_transparent", (VertexFormat)DefaultVertexFormat.POSITION_COLOR, (VertexFormat.Mode)VertexFormat.Mode.DEBUG_LINES, (int)1536, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(new RenderStateShard.ShaderStateShard(GameRenderer::getPositionColorShader)).setLineState(new RenderStateShard.LineStateShard(OptionalDouble.empty())).setLayeringState(RenderStateShard.NO_LAYERING).setTransparencyState(RenderStateShard.TRANSLUCENT_TRANSPARENCY).setWriteMaskState(RenderStateShard.COLOR_DEPTH_WRITE).setCullState(RenderStateShard.CULL).setDepthTestState(RenderStateShard.NO_DEPTH_TEST).createCompositeState(false));

    public static boolean renderLiteminerHighlight(PoseStack poseStack) {
        Minecraft mc = Minecraft.getInstance();
        ClientLevel level = mc.level;
        LocalPlayer player = mc.player;
        if (level == null || player == null) {
            return true;
        }
        if (!LiteminerClient.isVeinMining()) {
            return true;
        }
        HitResult result = mc.hitResult;
        if (result == null || result.getType() != HitResult.Type.BLOCK) {
            return true;
        }
        Walker walker = LiteminerClient.shapes.getCurrentItem();
        BlockPos origin = ShapelessWalker.raytraceBlock((Level)level, (Player)player);
        HashSet<BlockPos> blocksToHighlight = walker.walk((Level)level, (Player)player, ShapelessWalker.raytrace((Level)level, (Player)player).getBlockPos());
        LiteminerClient.selectedBlocks = blocksToHighlight;
        if (blocksToHighlight.isEmpty()) {
            return true;
        }
        Camera renderInfo = mc.gameRenderer.getMainCamera();
        Vec3 projectedView = renderInfo.getPosition();
        assert (poseStack != null);
        poseStack.pushPose();
        poseStack.translate((double)origin.getX() - projectedView.x, (double)origin.getY() - projectedView.y, (double)origin.getZ() - projectedView.z);
        Matrix4f matrix = poseStack.last().pose();
        HashSet<VoxelShape> shapes = new HashSet<VoxelShape>();
        for (AABB aabb : BoundingBoxMerger.merge(blocksToHighlight.stream().toList(), (BlockPos)origin)) {
            shapes.add(Shapes.create((AABB)aabb.inflate(0.005)));
        }
        MultiBufferSource.BufferSource buffers = mc.renderBuffers().bufferSource();
        VertexConsumer vertexBuilder2 = buffers.getBuffer(LINES_TRANSPARENT);
        BlockHighlightRenderer.orShapes(shapes).forAllEdges((x1, y1, z1, x2, y2, z2) -> {
            double dx = x2 - x1;
            double dy = y2 - y1;
            double dz = z2 - z1;
            double invMag = 1.0 / Math.sqrt(dx * dx + dy * dy + dz * dz);
            float nx = (float)(dx * invMag);
            float ny = (float)(dy * invMag);
            float nz = (float)(dz * invMag);
            PoseStack.Pose pose = poseStack.last();
            vertexBuilder2.addVertex(matrix, (float)x1, (float)y1, (float)z1).setColor(10, 206, 245, 180).setNormal(pose, nx, ny, nz);
            vertexBuilder2.addVertex(matrix, (float)x2, (float)y2, (float)z2).setColor(10, 206, 245, 180).setNormal(pose, nx, ny, nz);
        });
        buffers.endBatch(LINES_TRANSPARENT);
        VertexConsumer vertexBuilder = buffers.getBuffer(LINES_NORMAL);
        BlockHighlightRenderer.orShapes(shapes).forAllEdges((x1, y1, z1, x2, y2, z2) -> {
            vertexBuilder.addVertex(matrix, (float)x1, (float)y1, (float)z1).setColor(1.0f, 1.0f, 1.0f, 1.0f);
            vertexBuilder.addVertex(matrix, (float)x2, (float)y2, (float)z2).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        });
        buffers.endBatch(LINES_NORMAL);
        poseStack.popPose();
        return false;
    }

    static VoxelShape orShapes(Collection<VoxelShape> shapes) {
        VoxelShape combinedShape = Shapes.empty();
        for (VoxelShape shape : shapes) {
            combinedShape = Shapes.joinUnoptimized((VoxelShape)combinedShape, (VoxelShape)shape, (BooleanOp)BooleanOp.OR);
        }
        return combinedShape;
    }
}

