/*
 * Decompiled with CFR 0.152.
 */
package com.iamkaf.liteminer.networking;

import com.iamkaf.liteminer.Liteminer;
import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseC2SMessage;
import dev.architectury.networking.simple.MessageType;
import dev.architectury.networking.simple.SimpleNetworkManager;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;

public class LiteminerNetwork {
    public static final SimpleNetworkManager NET = SimpleNetworkManager.create((String)"liteminer");
    public static MessageType VEINMINE_KEYBIND_CHANGE = NET.registerC2S("veinmine_keybind_change", Messages.C2SVeinmineKeybindChange::new);

    public static void init() {
    }

    public static class Messages {

        public static class C2SVeinmineKeybindChange
        extends BaseC2SMessage {
            private final boolean keybindState;
            private final int shape;

            public C2SVeinmineKeybindChange(boolean keybindState, int shape) {
                this.keybindState = keybindState;
                this.shape = shape;
            }

            public C2SVeinmineKeybindChange(FriendlyByteBuf buf) {
                this.keybindState = buf.readBoolean();
                this.shape = buf.readInt();
            }

            public MessageType getType() {
                return VEINMINE_KEYBIND_CHANGE;
            }

            public void write(RegistryFriendlyByteBuf buf) {
                buf.writeBoolean(this.keybindState);
                buf.writeInt(this.shape);
            }

            public void encode(FriendlyByteBuf buf) {
                buf.writeBoolean(this.keybindState);
                buf.writeInt(this.shape);
            }

            public void handle(NetworkManager.PacketContext context) {
                Liteminer.instance.onKeymappingStateChange((ServerPlayer)context.getPlayer(), this.keybindState, this.shape);
            }

            public void apply(Supplier<NetworkManager.PacketContext> context) {
                Liteminer.instance.onKeymappingStateChange((ServerPlayer)context.get().getPlayer(), this.keybindState, this.shape);
            }
        }
    }
}

