/*
 * Decompiled with CFR 0.152.
 */
package com.iamkaf.liteminer.event;

import com.iamkaf.liteminer.Liteminer;
import com.iamkaf.liteminer.LiteminerPlayerState;
import com.iamkaf.liteminer.shapes.Walker;
import com.iamkaf.liteminer.tags.TagHelper;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.BlockEvent;
import dev.architectury.utils.value.IntValue;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IceBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class OnBlockBreak {
    public static void init() {
        BlockEvent.BREAK.register(OnBlockBreak::onBlockBreak);
    }

    private static EventResult onBlockBreak(Level level, BlockPos absoluteOrigin, BlockState blockState, ServerPlayer player, @Nullable IntValue intValue) {
        if (level.isClientSide) {
            return EventResult.pass();
        }
        LiteminerPlayerState playerState = Liteminer.instance.getPlayerState(player);
        if (!playerState.getKeymappingState()) {
            return EventResult.pass();
        }
        ItemStack tool = player.getMainHandItem();
        if (TagHelper.isExcludedTool(tool)) {
            return EventResult.pass();
        }
        if (tool.isDamageableItem() && tool.getMaxDamage() - tool.getDamageValue() == 1) {
            return EventResult.pass();
        }
        Walker walker = Liteminer.WALKERS.get(playerState.getShape());
        List<BlockPos> blocks = walker.walk(level, (Player)player, absoluteOrigin).stream().sorted(Comparator.comparingInt(p -> p.distManhattan((Vec3i)absoluteOrigin))).toList();
        for (BlockPos block : blocks) {
            boolean skipDrops;
            if (block.equals((Object)absoluteOrigin)) continue;
            if (player.isCreative()) {
                level.setBlockAndUpdate(block, Blocks.AIR.defaultBlockState());
                continue;
            }
            BlockState state = level.getBlockState(block);
            if (!tool.isEmpty() && tool.isDamageableItem()) {
                boolean itemIsAboutToBreak = tool.getMaxDamage() - tool.getDamageValue() <= 2;
                boolean preventFromBreaking = (Boolean)Liteminer.CONFIG.preventToolBreaking.get();
                if (itemIsAboutToBreak && preventFromBreaking) break;
                if (state.getDestroySpeed((BlockGetter)level, block) != 0.0f) {
                    tool.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
                }
            }
            boolean exhaustionEnabled = (Boolean)Liteminer.CONFIG.foodExhaustionEnabled.get();
            float exhaustion = ((Double)Liteminer.CONFIG.foodExhaustion.get()).floatValue();
            if (exhaustionEnabled && exhaustion > 0.0f) {
                player.causeFoodExhaustion(exhaustion);
            }
            boolean bl = skipDrops = state.requiresCorrectToolForDrops() && !tool.isCorrectToolForDrops(state);
            if (!skipDrops) {
                LootParams.Builder builder = new LootParams.Builder((ServerLevel)level).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)block)).withParameter(LootContextParams.TOOL, (Object)tool).withParameter(LootContextParams.BLOCK_STATE, (Object)state).withParameter(LootContextParams.THIS_ENTITY, (Object)player);
                if (state.hasBlockEntity()) {
                    builder = builder.withParameter(LootContextParams.BLOCK_ENTITY, (Object)Objects.requireNonNull(level.getBlockEntity(block)));
                }
                state.spawnAfterBreak((ServerLevel)level, absoluteOrigin, tool, true);
                for (ItemStack stack : state.getDrops(builder)) {
                    ItemEntity itemEntity = new ItemEntity(level, (double)absoluteOrigin.getX(), (double)absoluteOrigin.getY(), (double)absoluteOrigin.getZ(), stack, (double)(level.getRandom().nextFloat() / 10.0f), 0.25, (double)(level.getRandom().nextFloat() / 10.0f));
                    level.addFreshEntity((Entity)itemEntity);
                }
            }
            level.setBlockAndUpdate(block, Blocks.AIR.defaultBlockState());
            Block block2 = state.getBlock();
            if (!(block2 instanceof IceBlock)) continue;
            IceBlock ice = (IceBlock)block2;
            if (EnchantmentHelper.hasTag((ItemStack)tool, (TagKey)EnchantmentTags.PREVENTS_ICE_MELTING)) continue;
            if (level.dimensionType().ultraWarm()) {
                level.removeBlock(block, false);
                continue;
            }
            BlockState below = level.getBlockState(block.below());
            if (!OnBlockBreak.shouldMelt(below)) continue;
            level.setBlockAndUpdate(block, IceBlock.meltsInto());
        }
        return EventResult.pass();
    }

    private static boolean shouldMelt(BlockState below) {
        return below.blocksMotion() || below.liquid();
    }
}

