/*
 * Decompiled with CFR 0.152.
 */
package com.iamkaf.liteminer;

import com.iamkaf.liteminer.Liteminer;
import com.iamkaf.liteminer.config.KeyMode;
import com.iamkaf.liteminer.config.LiteminerClientConfig;
import com.iamkaf.liteminer.networking.LiteminerNetwork;
import com.iamkaf.liteminer.rendering.HUD;
import com.iamkaf.liteminer.shapes.Cycler;
import com.iamkaf.liteminer.shapes.Walker;
import com.mojang.blaze3d.platform.InputConstants;
import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.event.events.client.ClientRawInputEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.registry.client.keymappings.KeyMappingRegistry;
import java.util.HashSet;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class LiteminerClient {
    public static final int PACKET_DELAY = 125;
    public static final KeyMapping KEY_MAPPING = new KeyMapping("key.liteminer.veinmine", InputConstants.Type.KEYSYM, 96, "key.categories.liteminer");
    public static final LiteminerClientConfig CONFIG;
    public static final ModConfigSpec CONFIG_SPEC;
    public static HashSet<BlockPos> selectedBlocks;
    public static Minecraft mc;
    public static Cycler<Walker> shapes;
    private static boolean currentState;
    private static long lastChange;

    public static void init() {
        mc = Minecraft.getInstance();
        KeyMappingRegistry.register((KeyMapping)KEY_MAPPING);
        ClientTickEvent.CLIENT_POST.register(LiteminerClient::onPostTick);
        ClientGuiEvent.RENDER_HUD.register(HUD::onRenderHUD);
        ClientRawInputEvent.MOUSE_SCROLLED.register(HUD::onMouseScroll);
    }

    public static void onPostTick(Minecraft minecraft) {
        if (System.currentTimeMillis() - LiteminerClient.getLastChange() < 125L) {
            return;
        }
        switch ((KeyMode)((Object)LiteminerClient.CONFIG.keyMode.get())) {
            case HOLD: {
                boolean newState = KEY_MAPPING.isDown();
                if (newState == LiteminerClient.isVeinMining()) {
                    return;
                }
                new LiteminerNetwork.Messages.C2SVeinmineKeybindChange(newState, shapes.getCurrentIndex()).sendToServer();
                currentState = newState;
                break;
            }
            case TOGGLE: {
                if (!KEY_MAPPING.consumeClick()) break;
                boolean newState = !LiteminerClient.isVeinMining();
                new LiteminerNetwork.Messages.C2SVeinmineKeybindChange(newState, shapes.getCurrentIndex()).sendToServer();
                currentState = newState;
            }
        }
    }

    public static boolean isVeinMining() {
        return currentState;
    }

    public static long getLastChange() {
        return lastChange;
    }

    public static void setLastChange(long lastChange) {
        LiteminerClient.lastChange = lastChange;
    }

    public static boolean isTargetingABlock() {
        HitResult result = LiteminerClient.mc.hitResult;
        return result != null && result.getType() == HitResult.Type.BLOCK;
    }

    static {
        selectedBlocks = HashSet.newHashSet(0);
        shapes = new Cycler<Walker>(Liteminer.WALKERS);
        currentState = false;
        lastChange = System.currentTimeMillis();
        Pair pair = new ModConfigSpec.Builder().configure(LiteminerClientConfig::new);
        CONFIG = (LiteminerClientConfig)pair.getLeft();
        CONFIG_SPEC = (ModConfigSpec)pair.getRight();
    }
}

