/*
 * Decompiled with CFR 0.152.
 */
package com.iamkaf.liteminer;

import com.iamkaf.liteminer.LiteminerPlayerState;
import com.iamkaf.liteminer.config.LiteminerConfig;
import com.iamkaf.liteminer.event.Events;
import com.iamkaf.liteminer.networking.LiteminerNetwork;
import com.iamkaf.liteminer.shapes.ShapelessWalker;
import com.iamkaf.liteminer.shapes.StaircaseDownWalker;
import com.iamkaf.liteminer.shapes.StaircaseUpWalker;
import com.iamkaf.liteminer.shapes.ThreeByThreeWalker;
import com.iamkaf.liteminer.shapes.TunnelWalker;
import com.iamkaf.liteminer.shapes.Walker;
import com.mojang.logging.LogUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;

public final class Liteminer {
    public static final String MOD_ID = "liteminer";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final LiteminerConfig CONFIG;
    public static final ModConfigSpec CONFIG_SPEC;
    public static final List<Walker> WALKERS;
    public static Liteminer instance;
    public Map<UUID, LiteminerPlayerState> playerStateMap = new HashMap<UUID, LiteminerPlayerState>();

    public Liteminer() {
        instance = this;
    }

    public static void init() {
        LOGGER.info("Litemining, from poppies to deepslate.");
        LiteminerNetwork.init();
        Events.init();
    }

    public static ResourceLocation resource(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    public static float getScaledBreakSpeedModifier(int blockCount) {
        float modifier = ((Double)Liteminer.CONFIG.harvestTimePerBlockModifier.get()).floatValue();
        float blockBreakLimit = ((Integer)Liteminer.CONFIG.blockBreakLimit.get()).floatValue();
        return 1.0f - (float)blockCount / blockBreakLimit * modifier * 0.1f * 0.95f;
    }

    public LiteminerPlayerState getPlayerState(ServerPlayer player) {
        return this.playerStateMap.computeIfAbsent(player.getUUID(), LiteminerPlayerState::new);
    }

    public void onKeymappingStateChange(ServerPlayer player, boolean keybindState, int shape) {
        LiteminerPlayerState playerState = this.getPlayerState(player);
        playerState.setKeymappingState(keybindState);
        playerState.setShape(shape);
    }

    public float onBreakSpeed(ServerPlayer player, float originalSpeed) {
        LiteminerPlayerState playerState = this.getPlayerState(player);
        boolean isVeinMining = playerState.getKeymappingState();
        if (isVeinMining) {
            Level level = player.level();
            int blockCount = WALKERS.get(playerState.getShape()).walk(level, (Player)player, ShapelessWalker.raytrace(level, (Player)player).getBlockPos()).size();
            return Liteminer.getScaledBreakSpeedModifier(blockCount);
        }
        return 1.0f;
    }

    static {
        WALKERS = List.of(new ShapelessWalker(), new TunnelWalker(), new StaircaseUpWalker(), new StaircaseDownWalker(), new ThreeByThreeWalker());
        Pair pair = new ModConfigSpec.Builder().configure(LiteminerConfig::new);
        CONFIG = (LiteminerConfig)pair.getLeft();
        CONFIG_SPEC = (ModConfigSpec)pair.getRight();
    }
}

