/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.util;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import net.tslat.aoa3.client.ClientOperations;
import net.tslat.aoa3.common.registration.AoAGameRules;
import net.tslat.aoa3.common.registration.worldgen.AoADimensions;
import net.tslat.aoa3.content.entity.misc.CustomisableLightningBolt;
import net.tslat.aoa3.util.PlayerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WorldUtil {
    public static boolean checkGameRule(Level world, GameRules.Key<GameRules.BooleanValue> gameRule) {
        return world.getGameRules().getBoolean(gameRule);
    }

    public static Explosion createExplosion(@Nullable Entity exploder, Level world, BlockPos pos, float strength) {
        return WorldUtil.createExplosion(exploder, world, pos.getX(), pos.getY(), pos.getZ(), strength, AoAGameRules.checkDestructiveWeaponPhysics(world) ? Level.ExplosionInteraction.BLOCK : Level.ExplosionInteraction.NONE, false);
    }

    public static Explosion createExplosion(@NotNull Entity exploder, Level world, float strength) {
        return WorldUtil.createExplosion(exploder, world, exploder.getX(), exploder.getY(), exploder.getZ(), strength, EventHooks.canEntityGrief((Level)world, (Entity)exploder) ? Level.ExplosionInteraction.MOB : Level.ExplosionInteraction.NONE, false);
    }

    public static Explosion createExplosion(@Nullable Entity exploder, Level world, @NotNull Entity explodingEntity, float strength) {
        boolean doGriefing;
        if (exploder instanceof Player) {
            doGriefing = AoAGameRules.checkDestructiveWeaponPhysics(world);
        } else {
            if (exploder == null) {
                exploder = explodingEntity;
            }
            doGriefing = exploder instanceof LivingEntity || explodingEntity instanceof LivingEntity ? EventHooks.canEntityGrief((Level)world, (Entity)exploder) : AoAGameRules.checkDestructiveWeaponPhysics(world);
        }
        return WorldUtil.createExplosion(exploder, world, explodingEntity.getX(), explodingEntity.getY(), explodingEntity.getZ(), strength, doGriefing ? Level.ExplosionInteraction.MOB : Level.ExplosionInteraction.NONE, false);
    }

    public static Explosion createExplosion(@Nullable Entity exploder, Level world, double posX, double posY, double posZ, float strength) {
        return WorldUtil.createExplosion(exploder, world, posX, posY, posZ, strength, AoAGameRules.checkDestructiveWeaponPhysics(world) ? Level.ExplosionInteraction.BLOCK : Level.ExplosionInteraction.NONE, false);
    }

    public static Explosion createExplosion(@Nullable Entity exploder, Level world, double posX, double posY, double posZ, float strength, Level.ExplosionInteraction explosionType) {
        return WorldUtil.createExplosion(exploder, world, posX, posY, posZ, strength, explosionType, false);
    }

    public static Explosion createExplosion(@Nullable Entity exploder, Level world, double posX, double posY, double posZ, float strength, Level.ExplosionInteraction explosionType, boolean fieryExplosion) {
        return world.explode(exploder, posX, posY, posZ, strength, fieryExplosion, explosionType);
    }

    public static int getLightLevel(ServerLevelAccessor world, BlockPos position, boolean ignoreSkyLight, boolean ignoreBlockLight) {
        if (position.getY() > world.getMaxBuildHeight()) {
            position = new BlockPos(position.getX(), world.getMaxBuildHeight(), position.getZ());
        } else if (position.getY() < world.getMinBuildHeight()) {
            position = new BlockPos(position.getX(), world.getMinBuildHeight(), position.getZ());
        }
        if (ignoreSkyLight) {
            return world.getBrightness(LightLayer.BLOCK, position);
        }
        if (ignoreBlockLight) {
            return world.getBrightness(LightLayer.SKY, position) - world.getSkyDarken();
        }
        return world.getMaxLocalRawBrightness(position);
    }

    public static void spawnLightning(ServerLevel world, @Nullable ServerPlayer caster, double x, double y, double z, boolean destructive, boolean createFire) {
        CustomisableLightningBolt lightning = new CustomisableLightningBolt((Level)world, x, y, z);
        lightning.setVisualOnly(!destructive);
        if (!createFire) {
            lightning.noFire();
        }
        if (caster != null) {
            lightning.setCause(caster);
        }
        world.addFreshEntity((Entity)lightning);
    }

    public static boolean harvestAdditionalBlock(Level level, Player pl, BlockPos breakPos, boolean forceDropsInCreative) {
        BlockState blockState = level.getBlockState(breakPos);
        Block block = blockState.getBlock();
        if (blockState.isAir() || !level.mayInteract(pl, breakPos)) {
            return false;
        }
        if (pl instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)pl;
            GameType gameMode = serverPlayer.gameMode.getGameModeForPlayer();
            if (CommonHooks.fireBlockBreak((Level)level, (GameType)gameMode, (ServerPlayer)serverPlayer, (BlockPos)breakPos, (BlockState)blockState).isCanceled()) {
                return false;
            }
            BlockEntity blockEntity = level.getBlockEntity(breakPos);
            if (pl.isCreative()) {
                boolean canHarvest = forceDropsInCreative && blockState.canHarvestBlock((BlockGetter)level, breakPos, pl);
                boolean removed = blockState.onDestroyedByPlayer(level, breakPos, (Player)serverPlayer, false, level.getFluidState(breakPos));
                if (removed) {
                    blockState.getBlock().destroy((LevelAccessor)level, breakPos, blockState);
                    if (canHarvest) {
                        block.playerDestroy(level, pl, breakPos, blockState, blockEntity, pl.getMainHandItem().copy());
                    }
                }
            } else {
                boolean removedBlock;
                ItemStack toolStack = pl.getMainHandItem();
                ItemStack toolStackCopy = toolStack.copy();
                boolean canHarvest = blockState.canHarvestBlock((BlockGetter)level, breakPos, pl);
                if (toolStack.isEmpty() && !toolStackCopy.isEmpty()) {
                    EventHooks.onPlayerDestroyItem((Player)pl, (ItemStack)toolStackCopy, (InteractionHand)InteractionHand.MAIN_HAND);
                }
                if (removedBlock = blockState.onDestroyedByPlayer(level, breakPos, (Player)serverPlayer, false, level.getFluidState(breakPos))) {
                    blockState.getBlock().destroy((LevelAccessor)level, breakPos, blockState);
                    if (canHarvest) {
                        block.playerDestroy(level, pl, breakPos, blockState, blockEntity, toolStackCopy);
                    }
                }
            }
            return true;
        }
        return ClientOperations.harvestAdditionalBlock(breakPos);
    }

    public static float getAmbientTemperature(Level world, BlockPos pos) {
        Holder biome = world.getBiome(pos);
        float temp = ((Biome)biome.value()).getTemperature(pos);
        if (world.canSeeSky(pos)) {
            temp = world.isDay() ? (temp *= 1.35f) : (temp /= 1.35f);
            if (world.isRaining()) {
                Biome.Precipitation rainType = ((Biome)biome.value()).getPrecipitationAt(pos);
                if (rainType == Biome.Precipitation.SNOW) {
                    temp /= 1.5f;
                } else if (rainType == Biome.Precipitation.RAIN) {
                    temp /= 1.25f;
                }
            }
        }
        return temp;
    }

    public static int getHighestSafeLocation(Level world, int x, int z, boolean allowFluids, int minY) {
        if (Math.abs(x) > 30000000 || Math.abs(z) > 30000000) {
            return world.getMinBuildHeight();
        }
        BlockPos.MutableBlockPos testPos = new BlockPos.MutableBlockPos();
        boolean headBlock = false;
        boolean feetBlock = false;
        for (int i = Math.min(world.getHeight(Heightmap.Types.MOTION_BLOCKING, x, z) + 2, world.dimensionType().logicalHeight()); i > minY; --i) {
            BlockState state = world.getBlockState((BlockPos)testPos.set(x, i, z));
            if (state.isAir() || allowFluids && state.liquid()) {
                if (headBlock) {
                    if (feetBlock) continue;
                    feetBlock = true;
                    continue;
                }
                headBlock = true;
                continue;
            }
            if (!headBlock || !feetBlock) {
                headBlock = false;
                feetBlock = false;
                continue;
            }
            return i;
        }
        return minY;
    }

    public static boolean canPlaceBlock(LevelAccessor world, BlockPos pos, @Nullable Entity entity, @Nullable ItemStack stack) {
        if (!(world instanceof Level)) {
            return true;
        }
        Level activeWorld = (Level)world;
        Player relevantPlayer = PlayerUtil.getPlayerOrOwnerIfApplicable(entity);
        if (WorldUtil.isWorld(activeWorld, AoADimensions.NOWHERE)) {
            return relevantPlayer != null && relevantPlayer.isCreative();
        }
        if (relevantPlayer != null) {
            if (!relevantPlayer.mayBuild()) {
                return false;
            }
            GameType gameMode = PlayerUtil.getGameMode(relevantPlayer);
            if (gameMode == GameType.SPECTATOR) {
                return false;
            }
            if (gameMode == GameType.ADVENTURE && stack != null) {
                if (stack.isEmpty()) {
                    return false;
                }
                return stack.canPlaceOnBlockInAdventureMode(new BlockInWorld((LevelReader)activeWorld, pos, false));
            }
        }
        return true;
    }

    public static boolean canModifyBlock(LevelAccessor world, BlockPos pos, @Nullable Entity entity, @Nullable ItemStack stack) {
        if (!(world instanceof Level)) {
            return true;
        }
        Level activeWorld = (Level)world;
        Player relevantPlayer = PlayerUtil.getPlayerOrOwnerIfApplicable(entity);
        if (WorldUtil.isWorld(activeWorld, AoADimensions.NOWHERE)) {
            return relevantPlayer != null && relevantPlayer.isCreative();
        }
        if (relevantPlayer != null) {
            if (!relevantPlayer.mayBuild()) {
                return false;
            }
            GameType gameMode = PlayerUtil.getGameMode(relevantPlayer);
            if (gameMode == GameType.SPECTATOR) {
                return false;
            }
            if (gameMode == GameType.ADVENTURE && stack != null) {
                if (stack.isEmpty()) {
                    return false;
                }
                return stack.canBreakBlockInAdventureMode(new BlockInWorld((LevelReader)activeWorld, pos, false));
            }
        }
        return true;
    }

    public static void operateOnMultipleBlocksInRange(Level world, BlockPos center, int radius, Predicate<BlockState> test, Consumer<BlockPos> operation) {
        for (int x = center.getX() - radius; x < center.getX() + radius; ++x) {
            for (int y = center.getY() - radius; y < center.getY() + radius; ++y) {
                for (int z = center.getZ() - radius; z < center.getZ() + radius; ++z) {
                    BlockPos pos = new BlockPos(x, y, z);
                    if (!test.test(world.getBlockState(pos))) continue;
                    operation.accept(pos);
                }
            }
        }
    }

    public static List<BlockPos> getBlocksWithinAABB(Level world, AABB aabb, @Nullable BiPredicate<BlockState, BlockPos.MutableBlockPos> predicate) {
        BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos();
        ObjectArrayList matches = new ObjectArrayList();
        int x = (int)Math.floor(aabb.minX);
        while ((double)x <= Math.ceil(aabb.maxX)) {
            int y = (int)Math.floor(aabb.minY);
            while ((double)y <= Math.ceil(aabb.maxY)) {
                int z = (int)Math.floor(aabb.minZ);
                while ((double)z <= Math.ceil(aabb.maxZ)) {
                    checkPos.set(x, y, z);
                    if (predicate == null || predicate.test(world.getBlockState((BlockPos)checkPos), checkPos)) {
                        matches.add(checkPos.immutable());
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return matches;
    }

    public static boolean isWorld(ServerLevelAccessor world, ResourceKey<Level> ... keys) {
        for (ResourceKey<Level> key : keys) {
            if (world.getLevel().dimension() != key) continue;
            return true;
        }
        return false;
    }

    public static boolean isWorld(Level world, ResourceKey<Level> ... keys) {
        for (ResourceKey<Level> key : keys) {
            if (world.dimension() != key) continue;
            return true;
        }
        return false;
    }

    public static MinecraftServer getServer() {
        return ServerLifecycleHooks.getCurrentServer();
    }
}

