/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.util;

import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;

public final class TagUtil {
    public static <T> boolean isTaggedAs(Level level, T object, TagKey<T> ... tagKeys) {
        return level.registryAccess().registry(tagKeys[0].registry()).map(registry -> {
            Holder holder = registry.wrapAsHolder(object);
            for (TagKey tagKey : tagKeys) {
                if (!holder.is(tagKey)) continue;
                return true;
            }
            return false;
        }).orElse(false);
    }

    public static <T> Stream<TagKey<T>> getAllTagsFor(ResourceKey<? extends Registry<T>> registryKey, T object, Level level) {
        Registry registry = level.registryAccess().registry(registryKey).orElseGet(() -> (Registry)BuiltInRegistries.REGISTRY.getOrThrow(registryKey));
        return registry.getResourceKey(object).map(key -> registry.getHolderOrThrow(key).tags()).orElseGet(Stream::empty);
    }

    public static <T> Optional<HolderSet.Named<T>> getTagContents(TagKey<T> tag, Level level) {
        Optional vanillaRegistry = level.registryAccess().registry(tag.registry());
        return vanillaRegistry.map(registry -> registry.getTag(tag)).orElseGet(() -> ((Registry)BuiltInRegistries.REGISTRY.get(tag.registry())).getTag(tag));
    }
}

