/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.util;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Function;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;

public final class RecipeUtil {
    public static <R extends Recipe<?>> RecordCodecBuilder<R, NonNullList<Ingredient>> shapelessIngredientCodec(String recipeTypeName, Function<R, NonNullList<Ingredient>> getter) {
        return RecipeUtil.shapelessIngredientCodec(recipeTypeName, "ingredients", ShapedRecipePattern.getMaxWidth() * ShapedRecipePattern.getMaxHeight(), getter);
    }

    public static <R extends Recipe<?>> RecordCodecBuilder<R, NonNullList<Ingredient>> shapelessIngredientCodec(String recipeTypeName, String fieldName, int maxIngredients, Function<R, NonNullList<Ingredient>> getter) {
        return Ingredient.CODEC_NONEMPTY.listOf().fieldOf(fieldName).flatXmap(ingredients -> {
            Object[] ingredientArray = (Ingredient[])ingredients.toArray(Ingredient[]::new);
            if (ingredientArray.length == 0) {
                return DataResult.error(() -> "No ingredients for " + recipeTypeName + " recipe");
            }
            return ingredientArray.length > maxIngredients ? DataResult.error(() -> "Too many ingredients for " + recipeTypeName + " recipe. The maximum is: %s".formatted(maxIngredients)) : DataResult.success((Object)NonNullList.of((Object)Ingredient.EMPTY, (Object[])ingredientArray));
        }, DataResult::success).forGetter(getter);
    }

    public record RecipeBookDetails(String group, CraftingBookCategory category, boolean showUnlockNotification) {
        public static StreamCodec<RegistryFriendlyByteBuf, RecipeBookDetails> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, RecipeBookDetails::group, (StreamCodec)NeoForgeStreamCodecs.enumCodec(CraftingBookCategory.class), RecipeBookDetails::category, (StreamCodec)ByteBufCodecs.BOOL, RecipeBookDetails::showUnlockNotification, RecipeBookDetails::new);

        public static <T extends Recipe<?>> Products.P3<RecordCodecBuilder.Mu<T>, String, CraftingBookCategory, Boolean> codec(RecordCodecBuilder.Instance<T> builder, Function<T, RecipeBookDetails> getter) {
            return builder.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(instance -> ((RecipeBookDetails)getter.apply(instance)).group), (App)CraftingBookCategory.CODEC.optionalFieldOf("category", (Object)CraftingBookCategory.MISC).forGetter(instance -> ((RecipeBookDetails)getter.apply(instance)).category), (App)Codec.BOOL.optionalFieldOf("show_notification", (Object)true).forGetter(instance -> ((RecipeBookDetails)getter.apply(instance)).showUnlockNotification));
        }
    }
}

