/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.util;

import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.neoforged.neoforge.entity.PartEntity;
import net.tslat.smartbrainlib.util.EntityRetrievalUtil;
import net.tslat.smartbrainlib.util.RandomUtil;
import org.jetbrains.annotations.Nullable;

public final class PositionAndMotionUtil {
    public static Vec3 accountForGravity(Vec3 origin, Vec3 velocity, Vec3 targetPos, double gravity) {
        double latDist = targetPos.subtract(origin).horizontalDistance();
        double ticksToTravel = latDist / velocity.horizontalDistance();
        return velocity.add(0.0, 0.5 * gravity * Math.ceil(ticksToTravel), 0.0);
    }

    public static void turnToFace(Entity entity, Vec3 targetPosition) {
        Vec3 position = entity.getEyePosition();
        double lengthX = targetPosition.x() - position.x();
        double lengthY = targetPosition.y() - position.y();
        double lengthZ = targetPosition.z() - position.z();
        entity.setXRot((float)Math.toDegrees(Mth.atan2((double)lengthZ, (double)lengthX)) - 90.0f);
        entity.setYRot((float)Math.toDegrees(-Mth.atan2((double)lengthY, (double)Math.sqrt(lengthX * lengthX + lengthZ * lengthZ))));
        entity.xRotO = entity.getXRot();
        entity.yRotO = entity.getYRot();
    }

    public static void faceTowardsMotion(Entity entity) {
        Vec3 velocity = entity.getDeltaMovement();
        entity.setYRot((float)Math.toDegrees(Mth.atan2((double)velocity.x(), (double)velocity.z())));
        entity.setXRot((float)Math.toDegrees(Mth.atan2((double)velocity.y(), (double)velocity.horizontalDistance())));
        entity.yRotO = entity.getYRot();
        entity.xRotO = entity.getXRot();
    }

    public static void moveTowards(Entity entity, Vec3 targetPosition, double blocksPerSecond, double inaccuracy) {
        PositionAndMotionUtil.moveTowards(entity, targetPosition, blocksPerSecond, (double)0.0075f * inaccuracy, (double)0.0075f * inaccuracy);
    }

    public static void moveTowards(Entity entity, Vec3 targetPosition, double blocksPerSecond, double lateralVariance, double verticalVariance) {
        Vec3 origin = entity.position();
        Vec3 velocity = new Vec3(targetPosition.x() - origin.x(), targetPosition.y() - origin.y(), targetPosition.z() - origin.z()).normalize();
        if (lateralVariance != 0.0 || verticalVariance != 0.0) {
            velocity = velocity.add(RandomUtil.randomScaledGaussianValue((double)lateralVariance), RandomUtil.randomScaledGaussianValue((double)verticalVariance), RandomUtil.randomScaledGaussianValue((double)lateralVariance));
        }
        entity.setDeltaMovement(velocity.scale(blocksPerSecond));
    }

    public static void moveRelativeToFacing(Entity entity, double moveLeft, double moveForward, double moveUp) {
        entity.setPos(PositionAndMotionUtil.moveRelativeToFacing(entity.position(), entity.getYRot(), moveLeft, moveForward, moveUp));
    }

    public static Vec3 moveRelativeToFacing(Vec3 position, float yRot, double moveLeft, double moveForward, double moveUp) {
        double radians;
        double x = 0.0;
        double z = 0.0;
        if (moveLeft != 0.0) {
            radians = Math.toRadians(yRot - 180.0f);
            x += moveLeft * -Math.cos(radians);
            z += moveLeft * -Math.sin(radians);
        }
        if (moveForward != 0.0) {
            radians = Math.toRadians(yRot - 90.0f);
            x += moveForward * -Math.cos(radians);
            z += moveForward * -Math.sin(radians);
        }
        return position.add(x, moveUp, z);
    }

    public static boolean isNonVoidPosition(Level level, Vec3 pos) {
        int x = (int)Math.floor(pos.x);
        int z = (int)Math.floor(pos.z);
        if (x < -30000000 || z < -30000000 || x >= 30000000 || z >= 30000000) {
            return false;
        }
        return level.getHeight(Heightmap.Types.MOTION_BLOCKING, x, z) > level.getMinBuildHeight();
    }

    public static Vec3 moveDownToGround(Level level, Vec3 pos) {
        BlockPos.MutableBlockPos testPos = new BlockPos.MutableBlockPos(pos.x, pos.y, pos.z);
        LevelChunk chunk = level.getChunk(SectionPos.blockToSectionCoord((double)pos.x), SectionPos.blockToSectionCoord((double)pos.z));
        while (!chunk.getBlockState((BlockPos)testPos.move(Direction.DOWN)).blocksMotion() && testPos.getY() > level.getMinBuildHeight()) {
        }
        return new Vec3(pos.x, (double)testPos.getY(), pos.z);
    }

    public static Vec3 moveUpToSurface(Level level, Vec3 pos) {
        BlockPos.MutableBlockPos testPos = new BlockPos.MutableBlockPos(pos.x, pos.y, pos.z);
        LevelChunk chunk = level.getChunk(SectionPos.blockToSectionCoord((double)pos.x), SectionPos.blockToSectionCoord((double)pos.z));
        while (chunk.getBlockState((BlockPos)testPos.move(Direction.UP)).blocksMotion() && testPos.getY() < level.getMaxBuildHeight()) {
        }
        return new Vec3(pos.x, (double)testPos.getY(), pos.z);
    }

    public static Optional<Vec3> getNearestOnGroundPosition(Level level, Vec3 pos) {
        if (!PositionAndMotionUtil.isNonVoidPosition(level, pos)) {
            return Optional.empty();
        }
        pos = PositionAndMotionUtil.moveDownToGround(level, pos);
        pos = PositionAndMotionUtil.moveUpToSurface(level, pos);
        return Optional.of(pos);
    }

    public static HitResult rayTrace(Entity entity, double distance, boolean doEntities, @Nullable Predicate<Entity> entityFilter) {
        return PositionAndMotionUtil.rayTrace(entity.level(), entity.getEyePosition(), entity.getEyePosition().add(entity.getLookAngle().scale(distance)), ClipContext.Block.COLLIDER, false, doEntities, ((Predicate<Entity>)target -> target != entity).and(entityFilter == null ? target -> true : entityFilter));
    }

    public static HitResult rayTrace(Level level, Vec3 start, Vec3 end, ClipContext.Block blockhitType, boolean includeFluids, boolean doEntities, @Nullable Predicate<Entity> entityFilter) {
        BlockHitResult blockHitResult = level.clip(new ClipContext(start, end, blockhitType, includeFluids ? ClipContext.Fluid.ANY : ClipContext.Fluid.NONE, CollisionContext.empty()));
        if (!doEntities) {
            return blockHitResult;
        }
        if (blockHitResult.getType() == HitResult.Type.BLOCK) {
            end = blockHitResult.getLocation();
        }
        double distance = start.distanceTo(end);
        distance *= distance;
        Entity closestTarget = null;
        Vec3 clipPos = null;
        block0: for (Entity entity2 : EntityRetrievalUtil.getEntities((Level)level, (AABB)new AABB(start, end).inflate(1.0), entityFilter == null ? entity -> true : entityFilter)) {
            PartEntity[] parts = entity2.getParts();
            AABB entityPickBounds = entity2.getBoundingBox().inflate((double)entity2.getPickRadius());
            int partIndex = 0;
            while (true) {
                if (entityPickBounds.contains(start)) {
                    if (distance > 0.0) {
                        closestTarget = entity2;
                        distance = 0.0;
                        clipPos = entityPickBounds.clip(start, end).orElse(start);
                        continue block0;
                    }
                } else {
                    Vec3 clipPoint;
                    double entityDist;
                    Optional entityClip = entityPickBounds.clip(start, end);
                    if (entityClip.isPresent() && ((entityDist = start.distanceToSqr(clipPoint = (Vec3)entityClip.get())) < distance || distance == 0.0)) {
                        closestTarget = entity2;
                        clipPos = clipPoint;
                        distance = entityDist;
                        continue block0;
                    }
                }
                if (parts == null || ++partIndex >= parts.length) continue block0;
                entityPickBounds = parts[partIndex].getBoundingBox().inflate((double)entity2.getPickRadius());
            }
        }
        return closestTarget != null ? new EntityHitResult(closestTarget, clipPos) : blockHitResult;
    }
}

