/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.util;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.Nullable;

public final class NBTUtil {

    public static class NBTBuilder<T extends Tag> {
        private final T tag;
        private HashMap<String, NBTBuilder<?>> childTags;

        public NBTBuilder(T nbtBase) {
            this.tag = nbtBase;
        }

        public NBTBuilder<T> putTag(@Nullable String key, NBTBuilder<?> tag) {
            if (this.childTags == null) {
                this.childTags = new HashMap();
            }
            this.childTags.put(key, tag);
            return this;
        }

        public NBTBuilder<T> putString(@Nullable String key, String value) {
            if (this.tag.getType() == CompoundTag.TYPE && key != null) {
                ((CompoundTag)this.tag).putString(key, value);
            } else if (this.tag.getType() == ListTag.TYPE) {
                ((ListTag)this.tag).add((Object)StringTag.valueOf((String)value));
            }
            return this;
        }

        public NBTBuilder<T> putInteger(@Nullable String key, int value) {
            if (this.tag.getType() == CompoundTag.TYPE && key != null) {
                ((CompoundTag)this.tag).putInt(key, value);
            } else if (this.tag.getType() == ListTag.TYPE) {
                ((ListTag)this.tag).add((Object)IntTag.valueOf((int)value));
            }
            return this;
        }

        public NBTBuilder<T> putFloat(@Nullable String key, float value) {
            if (this.tag.getType() == CompoundTag.TYPE && key != null) {
                ((CompoundTag)this.tag).putFloat(key, value);
            } else if (this.tag.getType() == ListTag.TYPE) {
                ((ListTag)this.tag).add((Object)FloatTag.valueOf((float)value));
            }
            return this;
        }

        public NBTBuilder<T> putLong(@Nullable String key, long value) {
            if (this.tag.getType() == CompoundTag.TYPE && key != null) {
                ((CompoundTag)this.tag).putLong(key, value);
            } else if (this.tag.getType() == ListTag.TYPE) {
                ((ListTag)this.tag).add((Object)LongTag.valueOf((long)value));
            }
            return this;
        }

        public NBTBuilder<T> putByte(@Nullable String key, byte value) {
            if (this.tag.getType() == CompoundTag.TYPE && key != null) {
                ((CompoundTag)this.tag).putByte(key, value);
            } else if (this.tag.getType() == ListTag.TYPE) {
                ((ListTag)this.tag).add((Object)IntTag.valueOf((int)value));
            }
            return this;
        }

        public NBTBuilder<T> putBoolean(@Nullable String key, boolean value) {
            return this.putByte(key, value ? (byte)1 : 0);
        }

        public T build() {
            if (this.childTags != null && !this.childTags.isEmpty()) {
                if (this.tag.getType() == CompoundTag.TYPE) {
                    Map.Entry firstEntry = (Map.Entry)this.childTags.entrySet().stream().findFirst().get();
                    ((CompoundTag)this.tag).put((String)firstEntry.getKey(), ((NBTBuilder)firstEntry.getValue()).build());
                } else if (this.tag.getType() == ListTag.TYPE) {
                    for (Map.Entry<String, NBTBuilder<?>> childEntry : this.childTags.entrySet()) {
                        ((ListTag)this.tag).add(childEntry.getValue().build());
                    }
                }
            }
            return this.tag;
        }
    }
}

