/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.util;

import java.util.Iterator;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public final class MathUtil {
    public static Iterable<Vec3> inLateralCircle(final Vec3 center, final double radius, final double granularity) {
        return new Iterable<Vec3>(){

            @Override
            @NotNull
            public Iterator<Vec3> iterator() {
                return new Iterator<Vec3>(){
                    private final double increment;
                    private double theta;
                    {
                        this.increment = 6.2831854820251465 / granularity;
                        this.theta = 0.0;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.theta < 6.2831854820251465;
                    }

                    @Override
                    public Vec3 next() {
                        double angle = this.theta;
                        this.theta += this.increment;
                        return center.add(Math.cos(angle) * radius, 0.0, Math.sin(angle) * radius);
                    }
                };
            }
        };
    }

    public static Iterable<Vec3> inCircleAtAngle(final Vec3 center, final Vec3 angle, final double radius, final double granularity) {
        return new Iterable<Vec3>(){

            @Override
            @NotNull
            public Iterator<Vec3> iterator() {
                return new Iterator<Vec3>(){
                    private final double increment;
                    private final double yawLength;
                    private double theta;
                    {
                        this.increment = 6.2831854820251465 / granularity;
                        this.yawLength = angle.horizontalDistance();
                        this.theta = 0.0;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.theta < 6.2831854820251465;
                    }

                    @Override
                    public Vec3 next() {
                        double circleAngle = this.theta;
                        this.theta += this.increment;
                        double yaw = Math.cos(circleAngle) * radius;
                        double pitch = Math.sin(circleAngle) * radius;
                        return center.add(yaw * (Math.sinh(-angle.z) / this.yawLength) - pitch * angle.y * (angle.x / this.yawLength), pitch * this.yawLength, yaw * (Math.sinh(angle.x) / this.yawLength) - pitch * angle.y * (angle.z / this.yawLength));
                    }
                };
            }
        };
    }

    public static Iterable<Vec3> inLine(final Vec3 start, final Vec3 end, final double granularity) {
        return new Iterable<Vec3>(){

            @Override
            @NotNull
            public Iterator<Vec3> iterator() {
                return new Iterator<Vec3>(){
                    private final Vec3 angle;
                    private final double length;
                    private final double increment;
                    private double step;
                    {
                        this.angle = start.vectorTo(end).normalize();
                        this.length = start.distanceTo(end);
                        this.increment = this.length / granularity;
                        this.step = 0.0;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.step <= this.length;
                    }

                    @Override
                    public Vec3 next() {
                        double scale = this.step;
                        this.step += this.increment;
                        return start.add(this.angle.multiply(scale, scale, scale));
                    }
                };
            }
        };
    }

    public static Iterable<Vec3> inSphere(final Vec3 center, final double radius, final double granularity) {
        return new Iterable<Vec3>(){

            @Override
            @NotNull
            public Iterator<Vec3> iterator() {
                return new Iterator<Vec3>(){
                    private final double increment;
                    private double theta;
                    private double phi;
                    {
                        this.increment = 3.1415927410125732 / granularity;
                        this.theta = -1.5707963705062866;
                        this.phi = 0.0;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.theta < 1.5707963705062866 || this.phi < 6.2831854820251465;
                    }

                    @Override
                    public Vec3 next() {
                        double currentTheta = this.theta;
                        double currentPhi = this.phi;
                        if (this.phi >= 6.2831854820251465) {
                            this.theta += this.increment;
                            this.phi = 0.0;
                        }
                        this.phi += this.increment;
                        return center.add(Math.cos(currentTheta) * Math.sin(currentPhi) * radius, Math.cos(currentTheta) * Math.cos(currentPhi) * radius, Math.sin(currentTheta) * radius);
                    }
                };
            }
        };
    }

    public static Vec3 getPositionRelativeToAngle(Vec3 position, Vec3 relativePosition, Vec3 angle) {
        double angleLateralLength = angle.horizontalDistance();
        return position.add(new Vec3(relativePosition.x, relativePosition.y, relativePosition.x).multiply(Math.sinh(-angle.z) / angleLateralLength, angleLateralLength, Math.sinh(angle.x) / angleLateralLength).subtract(relativePosition.y * angle.y * (angle.x / angleLateralLength), 0.0, relativePosition.y * angle.y * (angle.z / angleLateralLength)).add(angle.scale(relativePosition.z)));
    }

    public static Vec3 clampVec(Vec3 vec, Vec3 min, Vec3 max) {
        return new Vec3(Mth.clamp((double)vec.x, (double)min.x, (double)max.x), Mth.clamp((double)vec.y, (double)min.y, (double)max.y), Mth.clamp((double)vec.z, (double)min.z, (double)max.z));
    }

    public static float getYawForVector(Vec3 origin, Vec3 target) {
        Vec3 angle = origin.vectorTo(target);
        return (float)Mth.atan2((double)angle.z, (double)angle.x) - 1.5707964f;
    }

    public static float getPitchForVector(Vec3 origin, Vec3 target) {
        Vec3 angle = origin.vectorTo(target);
        return -((float)Mth.atan2((double)angle.y, (double)angle.horizontalDistance()));
    }

    public static Vec3 getEyelineForward(Entity entity) {
        return Vec3.directionFromRotation((float)0.0f, (float)entity.getYRot());
    }

    public static Vec3 getEyelineRight(Entity entity) {
        return Vec3.directionFromRotation((float)0.0f, (float)(entity.getYRot() + 90.0f));
    }

    public static Vec3 getBodyForward(LivingEntity entity) {
        return Vec3.directionFromRotation((float)0.0f, (float)entity.yBodyRot);
    }

    public static Vec3 getBodyRight(LivingEntity entity) {
        return Vec3.directionFromRotation((float)0.0f, (float)(entity.yBodyRot + 90.0f));
    }
}

