/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.util;

import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.EventHooks;
import net.tslat.aoa3.common.registration.AoATags;
import net.tslat.aoa3.common.registration.item.AoAArmourMaterials;
import net.tslat.aoa3.common.registration.item.AoAEnchantments;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.PlayerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ItemUtil {
    public static void consume(LivingEntity entity, ItemStack stack) {
        ItemUtil.consume(entity, stack, 1);
    }

    public static void consume(LivingEntity entity, ItemStack stack, int amount) {
        if (!entity.level().isClientSide && !entity.hasInfiniteMaterials()) {
            ItemUtil.consume(stack, amount);
        }
    }

    public static void consume(ItemStack stack) {
        ItemUtil.consume(stack, 1);
    }

    public static void consume(ItemStack stack, int amount) {
        stack.shrink(amount);
    }

    public static void damageItemForUser(Player player, InteractionHand hand) {
        ItemUtil.damageItemForUser(player, 1, hand);
    }

    public static void damageItemForUser(Player player, EquipmentSlot slot) {
        ItemUtil.damageItemForUser(player, 1, slot);
    }

    public static void damageItemForUser(Player player, ItemStack stack, InteractionHand hand) {
        ItemUtil.damageItemForUser(player, stack, 1, hand);
    }

    public static void damageItemForUser(Player player, ItemStack stack, EquipmentSlot slot) {
        ItemUtil.damageItemForUser(player, stack, 1, slot);
    }

    public static void damageItemForUser(Player player, int amount, InteractionHand hand) {
        ServerPlayer pl;
        if (player instanceof ServerPlayer && !(pl = (ServerPlayer)player).hasInfiniteMaterials()) {
            ItemUtil.damageItemForUser(pl.serverLevel(), (LivingEntity)pl, amount, hand);
        }
    }

    public static void damageItemForUser(Player player, int amount, EquipmentSlot slot) {
        ServerPlayer pl;
        if (player instanceof ServerPlayer && !(pl = (ServerPlayer)player).hasInfiniteMaterials()) {
            ItemUtil.damageItemForUser(pl.serverLevel(), (LivingEntity)pl, amount, slot);
        }
    }

    public static void damageItemForUser(Player player, ItemStack stack, int amount, InteractionHand hand) {
        ServerPlayer pl;
        if (player instanceof ServerPlayer && !(pl = (ServerPlayer)player).hasInfiniteMaterials()) {
            ItemUtil.damageItemForUser(pl.serverLevel(), stack, amount, (LivingEntity)pl, EntityUtil.handToEquipmentSlotType(hand));
        }
    }

    public static void damageItemForUser(Player player, ItemStack stack, int amount, EquipmentSlot slot) {
        ServerPlayer pl;
        if (player instanceof ServerPlayer && !(pl = (ServerPlayer)player).hasInfiniteMaterials()) {
            ItemUtil.damageItemForUser(pl.serverLevel(), stack, amount, (LivingEntity)pl, slot);
        }
    }

    public static void damageItemForUser(ServerLevel level, LivingEntity user, InteractionHand hand) {
        ItemUtil.damageItemForUser(level, user, 1, hand);
    }

    public static void damageItemForUser(ServerLevel level, LivingEntity user, int amount, InteractionHand hand) {
        EquipmentSlot slot = EntityUtil.handToEquipmentSlotType(hand);
        ItemUtil.damageItemForUser(level, user.getItemBySlot(slot), amount, user, slot);
    }

    public static void damageItemForUser(ServerLevel level, LivingEntity user, EquipmentSlot slot) {
        ItemUtil.damageItemForUser(level, user.getItemBySlot(slot), user, slot);
    }

    public static void damageItemForUser(ServerLevel level, LivingEntity user, int amount, EquipmentSlot slot) {
        ItemUtil.damageItemForUser(level, user.getItemBySlot(slot), amount, user, slot);
    }

    public static void damageItemForUser(ServerLevel level, ItemStack stack, LivingEntity user, EquipmentSlot slot) {
        ItemUtil.damageItemForUser(level, stack, 1, user, slot);
    }

    public static void damageItemForUser(ServerLevel level, ItemStack stack, LivingEntity user, InteractionHand hand) {
        ItemUtil.damageItemForUser(level, stack, 1, user, EntityUtil.handToEquipmentSlotType(hand));
    }

    public static void damageItemForUser(ServerLevel level, ItemStack stack, int amount, LivingEntity user, InteractionHand hand) {
        ItemUtil.damageItemForUser(level, stack, amount, user, EntityUtil.handToEquipmentSlotType(hand));
    }

    public static void damageItemForUser(ServerLevel level, ItemStack stack, int amount, LivingEntity user, EquipmentSlot slot) {
        ItemUtil.damageItem(level, stack, amount, user, item -> {
            user.onEquippedItemBroken(item, slot);
            if (user instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)user;
                EventHooks.onPlayerDestroyItem((Player)player, (ItemStack)stack, slot.isArmor() ? null : (slot == EquipmentSlot.MAINHAND ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND));
            }
        });
    }

    public static void damageItemForUser(ServerLevel level, ItemStack stack, int amount, LivingEntity user, Consumer<Item> onBreak) {
        ItemUtil.damageItem(level, stack, amount, user, onBreak);
    }

    public static void damageItemNoUser(ServerLevel level, ItemStack stack) {
        ItemUtil.damageItemNoUser(level, stack, 1);
    }

    public static void damageItemNoUser(ServerLevel level, ItemStack stack, int amount) {
        ItemUtil.damageItemNoUser(level, stack, amount, item -> {});
    }

    public static void damageItemNoUser(ServerLevel level, ItemStack stack, int amount, Consumer<Item> onBreak) {
        ItemUtil.damageItem(level, stack, amount, null, onBreak);
    }

    public static void damageItem(ServerLevel level, ItemStack stack, int amount, @Nullable LivingEntity entity, Consumer<Item> onBreak) {
        stack.hurtAndBreak(amount, level, entity, onBreak);
    }

    public static ItemStack damageAndConvertIfBroken(ServerLevel level, ItemStack stack, ItemLike convertTo) {
        return ItemUtil.damageAndConvertIfBroken(level, stack, 1, convertTo, null, (Item item) -> {});
    }

    public static ItemStack damageAndConvertIfBroken(ServerLevel level, ItemStack stack, ItemLike convertTo, LivingEntity user, EquipmentSlot slot) {
        return ItemUtil.damageAndConvertIfBroken(level, stack, 1, convertTo, user, slot);
    }

    public static ItemStack damageAndConvertIfBroken(ServerLevel level, ItemStack stack, int amount, ItemLike convertTo, LivingEntity user, EquipmentSlot slot) {
        return ItemUtil.damageAndConvertIfBroken(level, stack, amount, convertTo, user, (Item item) -> {
            user.onEquippedItemBroken(item, slot);
            if (user instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)user;
                EventHooks.onPlayerDestroyItem((Player)player, (ItemStack)stack, slot.isArmor() ? null : (slot == EquipmentSlot.MAINHAND ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND));
            }
        });
    }

    public static ItemStack damageAndConvertIfBroken(ServerLevel level, ItemStack stack, int amount, ItemLike convertTo, @Nullable LivingEntity entity, Consumer<Item> onBreak) {
        ItemUtil.damageItem(level, stack, amount, entity, onBreak);
        if (stack.isEmpty()) {
            ItemStack copy = new ItemStack((Holder)convertTo.asItem().builtInRegistryHolder(), 1, stack.getComponentsPatch());
            if (copy.isDamageableItem()) {
                copy.setDamageValue(0);
            }
            return copy;
        }
        return stack;
    }

    public static boolean findAndConsumeRunes(Object2IntMap<Item> runeMap, ServerPlayer player, boolean allowBuffs, @NotNull ItemStack heldItem) {
        int amount;
        Item type;
        if (player.isCreative()) {
            return true;
        }
        Reference2IntOpenHashMap requiredRunes = new Reference2IntOpenHashMap(runeMap);
        boolean nightmareArmour = allowBuffs && PlayerUtil.isWearingFullSet((Player)player, AoAArmourMaterials.NIGHTMARE);
        for (Item item : requiredRunes.keySet()) {
            requiredRunes.computeIntIfPresent((Object)item, (rune, cost) -> {
                if (allowBuffs) {
                    cost = Mth.ceil((float)AoAEnchantments.modifyRuneCost(player.serverLevel(), heldItem, cost));
                    if (nightmareArmour) {
                        if (rune == AoAItems.DISTORTION_RUNE.get()) {
                            return null;
                        }
                        cost = Math.max(cost - 1, 1);
                    }
                }
                return Mth.ceil((float)AoAEnchantments.modifyAmmoCost((Level)player.serverLevel(), heldItem, cost));
            });
        }
        if (requiredRunes.isEmpty()) {
            return true;
        }
        IntOpenHashSet runeSlots = new IntOpenHashSet();
        Reference2IntOpenHashMap runeCounter = new Reference2IntOpenHashMap((Reference2IntMap)requiredRunes);
        ItemStack mainHandStack = player.getItemInHand(InteractionHand.MAIN_HAND);
        ItemStack offHandStack = player.getItemInHand(InteractionHand.OFF_HAND);
        if (mainHandStack.is(AoATags.Items.ADVENT_RUNE) && runeCounter.containsKey((Object)(type = mainHandStack.getItem()))) {
            amount = runeCounter.getInt((Object)type);
            runeSlots.add(-1);
            if ((amount -= mainHandStack.getCount()) > 0) {
                runeCounter.put((Object)type, amount);
            } else {
                runeCounter.removeInt((Object)type);
            }
        }
        if (!runeCounter.isEmpty() && offHandStack.is(AoATags.Items.ADVENT_RUNE) && runeCounter.containsKey((Object)(type = offHandStack.getItem()))) {
            amount = runeCounter.getInt((Object)type);
            runeSlots.add(-2);
            if ((amount -= offHandStack.getCount()) > 0) {
                runeCounter.put((Object)type, amount);
            } else {
                runeCounter.removeInt((Object)type);
            }
        }
        if (!runeCounter.isEmpty()) {
            for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
                Item type2;
                ItemStack stack = player.getInventory().getItem(i);
                if (!stack.is(AoATags.Items.ADVENT_RUNE) || !runeCounter.containsKey((Object)(type2 = stack.getItem()))) continue;
                int amount2 = runeCounter.getInt((Object)type2);
                runeSlots.add(i);
                if ((amount2 -= stack.getCount()) > 0) {
                    runeCounter.put((Object)type2, amount2);
                } else {
                    runeCounter.removeInt((Object)type2);
                }
                if (runeCounter.isEmpty()) break;
            }
        }
        if (runeCounter.isEmpty()) {
            int remaining;
            if (runeSlots.contains(-1)) {
                ItemStack rune2 = player.getItemInHand(InteractionHand.MAIN_HAND);
                Item type3 = rune2.getItem();
                int amount3 = requiredRunes.getInt((Object)type3);
                remaining = amount3 - rune2.getCount();
                rune2.shrink(amount3);
                if (remaining <= 0) {
                    requiredRunes.removeInt((Object)type3);
                } else {
                    requiredRunes.put((Object)type3, remaining);
                }
                runeSlots.remove(-1);
            }
            if (runeSlots.contains(-2)) {
                ItemStack rune3 = player.getItemInHand(InteractionHand.OFF_HAND);
                Item type4 = rune3.getItem();
                int amount4 = requiredRunes.getInt((Object)type4);
                remaining = amount4 - rune3.getCount();
                rune3.shrink(amount4);
                if (remaining <= 0) {
                    requiredRunes.removeInt((Object)type4);
                } else {
                    requiredRunes.put((Object)type4, remaining);
                }
                runeSlots.remove(-2);
            }
            IntIterator intIterator = runeSlots.iterator();
            while (intIterator.hasNext()) {
                int slotId = (Integer)intIterator.next();
                ItemStack rune4 = player.getInventory().getItem(slotId);
                Item type5 = rune4.getItem();
                int amount5 = requiredRunes.getInt((Object)type5);
                int remaining2 = amount5 - rune4.getCount();
                rune4.shrink(amount5);
                if (remaining2 <= 0) {
                    requiredRunes.removeInt((Object)type5);
                } else {
                    requiredRunes.put((Object)type5, remaining2);
                }
                if (!requiredRunes.isEmpty()) continue;
                break;
            }
            return true;
        }
        return false;
    }

    public static List<ItemStack> increaseStackSize(ItemStack stack, int addAmount) {
        int maxCount = stack.getMaxStackSize();
        if (stack.getCount() + addAmount <= maxCount) {
            stack.grow(addAmount);
            return Collections.emptyList();
        }
        ObjectArrayList newStacks = new ObjectArrayList((int)((float)(addAmount + stack.getCount()) / (float)maxCount));
        while (addAmount > 0) {
            ItemStack copy = stack.copy();
            copy.setCount(Math.min(maxCount, addAmount));
            newStacks.add(copy);
            addAmount -= copy.getCount();
        }
        return newStacks;
    }
}

