/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.util;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.CombatEntry;
import net.minecraft.world.damagesource.CombatTracker;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.entity.PartEntity;
import net.tslat.aoa3.util.AttributeUtil;
import net.tslat.effectslib.api.util.EffectBuilder;
import net.tslat.smartbrainlib.util.EntityRetrievalUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EntityUtil {
    public static boolean isHostileMob(Entity entity) {
        NeutralMob neutralMob;
        return entity instanceof Enemy || entity instanceof NeutralMob && (neutralMob = (NeutralMob)entity).isAngry();
    }

    public static void healEntity(LivingEntity entity, float amount) {
        if (amount > 0.0f && entity.isAlive() && entity.getHealth() > 0.0f && entity.getHealth() < entity.getMaxHealth()) {
            entity.heal(amount);
        }
    }

    public static float getHealthPercent(LivingEntity entity) {
        return entity.getHealth() / entity.getMaxHealth();
    }

    public static boolean isImmuneToSpecialAttacks(Entity target) {
        LivingEntity livingTarget;
        return target instanceof Player || target.isInvulnerable() || target.getType().is(Tags.EntityTypes.BOSSES) || target instanceof LivingEntity && (livingTarget = (LivingEntity)target).getMaxHealth() > 500.0f;
    }

    public static float getAttackCooldown(LivingEntity entity) {
        if (entity instanceof Player) {
            Player pl = (Player)entity;
            return pl.getAttackStrengthScale(0.0f);
        }
        return entity.swinging ? (float)entity.swingTime / (float)entity.getCurrentSwingDuration() : 1.0f;
    }

    public static boolean isFlyingCreature(Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return false;
        }
        if (entity instanceof FlyingMob || entity instanceof FlyingAnimal) {
            return true;
        }
        if (!(entity instanceof Mob)) {
            return false;
        }
        Mob mob = (Mob)entity;
        return mob.getNavigation() instanceof FlyingPathNavigation || mob.getMoveControl() instanceof FlyingMoveControl;
    }

    public static void pushEntityAway(@NotNull Entity centralEntity, @NotNull Entity targetEntity, float strength) {
        double knockbackResist;
        if (targetEntity instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)targetEntity;
            v0 = Math.min(AttributeUtil.getAttributeValue(target, (Holder<Attribute>)Attributes.KNOCKBACK_RESISTANCE), 1.0);
        } else {
            v0 = knockbackResist = 0.0;
        }
        if (knockbackResist >= 1.0) {
            return;
        }
        targetEntity.setDeltaMovement(targetEntity.getDeltaMovement().add(centralEntity.position().vectorTo(targetEntity.position()).scale((1.0 - knockbackResist) * (double)strength)));
        targetEntity.hurtMarked = true;
    }

    public static void pullEntityIn(@NotNull Entity centralEntity, @NotNull Entity targetEntity, float strength, boolean normalised) {
        Vec3 targetMotion = targetEntity.getDeltaMovement();
        Vec3 velocity = new Vec3(centralEntity.getX() - targetEntity.getX() + targetMotion.x(), centralEntity.getY() - targetEntity.getY() + targetMotion.y(), centralEntity.getZ() - targetEntity.getZ() + targetMotion.z());
        if (normalised) {
            velocity = velocity.normalize();
        }
        velocity = velocity.scale((double)strength);
        targetEntity.setDeltaMovement(velocity);
        targetEntity.hurtMarked = true;
    }

    public static void applyPotions(Collection<? extends Entity> entities, EffectBuilder ... effects) {
        for (Entity entity : entities) {
            EntityUtil.applyPotions(entity, effects);
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void applyPotions(Entity entity, EffectBuilder ... effects) {
        block7: {
            block6: {
                if (!((entity = EntityUtil.getPartOrPartOwner(entity)) instanceof LivingEntity)) break block6;
                target = (LivingEntity)entity;
                if (entity.isAlive() && !entity.isSpectator() && !(entity instanceof FakePlayer)) break block7;
            }
            return;
        }
        if (!(entity instanceof Player)) ** GOTO lbl-1000
        pl = (Player)entity;
        if (pl.getAbilities().invulnerable) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        onlyBeneficial = v0;
        for (EffectBuilder builder : effects) {
            if (onlyBeneficial && !((MobEffect)builder.getEffect().value()).isBeneficial()) continue;
            target.addEffect(builder.build());
        }
    }

    public static void removePotions(LivingEntity entity, Holder<MobEffect> ... effects) {
        for (Holder<MobEffect> effect : effects) {
            if (!entity.hasEffect(effect)) continue;
            entity.removeEffect(effect);
        }
    }

    public static boolean isPlayerLookingAtEntity(Player pl, Entity target) {
        return EntityUtil.isPlayerLookingAt(pl, target.getX(), target.getBoundingBox().minY + (double)target.getBbHeight() / 2.0, target.getZ()) && pl.hasLineOfSight(target);
    }

    public static boolean isPlayerLookingAt(Player pl, double posX, double posY, double posZ) {
        Vec3 playerLookVec = pl.getLookAngle().normalize();
        Vec3 requiredLookVec = new Vec3(posX - pl.getX(), posY - (pl.getY() + (double)pl.getEyeHeight()), posZ - pl.getZ());
        double requiredLookVecLength = requiredLookVec.length();
        double vecDotProduct = playerLookVec.dot(requiredLookVec = requiredLookVec.normalize());
        return vecDotProduct > 1.0 - 0.025 / requiredLookVecLength;
    }

    public static boolean isNaturalSpawnReason(MobSpawnType reason) {
        return reason == MobSpawnType.CHUNK_GENERATION || reason == MobSpawnType.NATURAL;
    }

    @Nullable
    public static Vec3 preciseEntityInterceptCalculation(Entity impactedEntity, Entity impactingEntity, int granularity) {
        Vec3 vecVelocity = impactingEntity.getDeltaMovement();
        double velocityX = vecVelocity.x();
        double velocityY = vecVelocity.y();
        double velocityZ = vecVelocity.z();
        for (int i = 0; i < granularity; ++i) {
            double projectionX = velocityX * (double)(1.0f / (float)granularity) * (double)i;
            double projectionY = velocityY * (double)(1.0f / (float)granularity) * (double)i;
            double projectionZ = velocityZ * (double)(1.0f / (float)granularity) * (double)i;
            Vec3 initialVec = new Vec3(impactingEntity.getX(), impactingEntity.getY(), impactingEntity.getZ());
            Vec3 projectedVec = initialVec.add(projectionX, projectionY, projectionZ);
            List entityList = impactingEntity.level().getEntities(impactingEntity, impactingEntity.getBoundingBox().inflate(projectionX, projectionY, projectionZ));
            for (Entity entity : entityList) {
                Optional intercept;
                if (entity != impactedEntity || !(intercept = entity.getBoundingBox().clip(initialVec, projectedVec)).isPresent()) continue;
                return (Vec3)intercept.get();
            }
        }
        return null;
    }

    public static boolean canPvp(Player attacker, Player target) {
        return attacker.level().getServer().isPvpAllowed() && attacker != target && !attacker.isAlliedTo((Entity)target);
    }

    public static Direction getDirectionFacing(Entity entity, boolean lateralOnly) {
        if (!lateralOnly) {
            if (entity.getXRot() < -50.0f) {
                return Direction.DOWN;
            }
            if (entity.getXRot() > 50.0f) {
                return Direction.UP;
            }
        }
        int vec = Mth.floor((double)((double)(entity.getYRot() * 4.0f / 360.0f) + 0.5)) & 3;
        return switch (++vec % 4) {
            case 0 -> Direction.EAST;
            case 1 -> Direction.SOUTH;
            case 2 -> Direction.WEST;
            default -> Direction.NORTH;
        };
    }

    @NotNull
    public static Set<Entity> getAttackersForMob(LivingEntity entity, @Nullable Predicate<Entity> filter) {
        CombatTracker tracker = entity.getCombatTracker();
        if (tracker.entries.isEmpty()) {
            Entity attacker;
            if (entity.getLastDamageSource() != null && (attacker = entity.getLastDamageSource().getEntity()) != null && (filter == null || filter.test(attacker))) {
                return Set.of(entity.getLastDamageSource().getEntity());
            }
            return Collections.emptySet();
        }
        ObjectOpenHashSet killers = new ObjectOpenHashSet(tracker.entries.size());
        for (CombatEntry entry : tracker.entries) {
            Entity entity2 = entry.source().getEntity();
            if (!(entity2 instanceof LivingEntity)) continue;
            LivingEntity attacker = (LivingEntity)entity2;
            if (filter != null && !filter.test((Entity)attacker)) continue;
            killers.add(attacker);
        }
        return killers;
    }

    public static Vec3 getDirectionForFacing(Entity entity) {
        return new Vec3((double)(-Mth.sin((float)(entity.getYRot() * (float)Math.PI / 180.0f))), (double)(-Mth.sin((float)(entity.getXRot() * (float)Math.PI / 180.0f))), (double)Mth.cos((float)(entity.getYRot() * (float)Math.PI / 180.0f)));
    }

    public static Vec3 getVelocityVectorForFacing(Entity entity) {
        return EntityUtil.getVelocityVectorForFacing(entity, 1.0f);
    }

    public static Vec3 getVelocityVectorForFacing(Entity entity, float velocityMod) {
        return new Vec3((double)(-Mth.sin((float)(entity.getYRot() * (float)Math.PI / 180.0f)) * Mth.cos((float)(entity.getXRot() * (float)Math.PI / 180.0f)) * velocityMod), (double)(-Mth.sin((float)(entity.getXRot() * (float)Math.PI / 180.0f)) * velocityMod), (double)(Mth.cos((float)(entity.getYRot() * (float)Math.PI / 180.0f)) * Mth.cos((float)(entity.getXRot() * (float)Math.PI / 180.0f)) * velocityMod));
    }

    public static boolean isEntityMoving(Entity entity) {
        Vec3 velocity = entity.getDeltaMovement();
        return velocity.x() != 0.0 || velocity.z() != 0.0 || velocity.y() > -0.07 || velocity.y() < -0.08;
    }

    public static Vec3 getEntityCenter(Entity entity) {
        return new Vec3(entity.getX(0.5), entity.getY(0.5), entity.getZ(0.5));
    }

    @Nullable
    public static <T extends Entity> EntityHitResult getEntityCollisionWithPrecision(Level level, Entity projectile, Vec3 startVec, Vec3 endVec, AABB bounds, Predicate<T> filter, float tolerance) {
        double closestDist = Double.MAX_VALUE;
        Entity impactEntity = null;
        Vec3 position = null;
        for (Entity target : EntityRetrievalUtil.getEntities((Level)level, (AABB)bounds, entity -> entity != projectile && filter.test(entity))) {
            Vec3 pos;
            double dist;
            AABB targetBounds = target.getBoundingBox().inflate((double)tolerance);
            Optional boundsClip = targetBounds.clip(startVec, endVec);
            if (boundsClip.isPresent() && (dist = startVec.distanceToSqr(pos = (Vec3)boundsClip.get())) < closestDist) {
                impactEntity = target;
                closestDist = dist;
                position = pos;
            }
            if (!target.isMultipartEntity()) continue;
            for (PartEntity part : target.getParts()) {
                Vec3 pos2;
                double dist2;
                targetBounds = part.getBoundingBox().inflate((double)tolerance);
                boundsClip = targetBounds.clip(startVec, endVec);
                if (!boundsClip.isPresent() || !((dist2 = startVec.distanceToSqr(pos2 = (Vec3)boundsClip.get())) < closestDist)) continue;
                impactEntity = target;
                closestDist = dist2;
                position = pos2;
            }
        }
        return impactEntity == null ? null : new EntityHitResult(impactEntity, position);
    }

    public static Entity getPartOrPartOwner(Entity entity) {
        if (entity instanceof PartEntity) {
            PartEntity part = (PartEntity)entity;
            return part.getParent();
        }
        return entity;
    }

    public static boolean isAllyOf(Entity entity1, Entity entity2) {
        OwnableEntity ownable;
        if (entity1 == entity2) {
            return true;
        }
        if (entity1.isAlliedTo(entity2)) {
            return true;
        }
        if (entity1 instanceof OwnableEntity) {
            ownable = (OwnableEntity)entity1;
            if (entity2.getUUID().equals(ownable.getOwnerUUID())) {
                return true;
            }
        }
        if (entity2 instanceof OwnableEntity) {
            ownable = (OwnableEntity)entity2;
            if (entity1.getUUID().equals(ownable.getOwnerUUID())) {
                return true;
            }
        }
        return false;
    }

    public static EquipmentSlot handToEquipmentSlotType(InteractionHand hand) {
        return hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND;
    }
}

