/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.util;

import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.damagesource.DamageContainer;
import net.neoforged.neoforge.entity.PartEntity;
import net.neoforged.neoforge.event.entity.living.LivingKnockBackEvent;
import net.tslat.aoa3.common.registration.AoATags;
import net.tslat.aoa3.common.registration.entity.AoADamageTypes;
import net.tslat.aoa3.content.item.armour.AdventArmour;
import net.tslat.aoa3.util.NumberUtil;
import net.tslat.aoa3.util.PlayerUtil;
import net.tslat.aoa3.util.RegistryUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DamageUtil {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T extends Entity> boolean isAttackable(T entity) {
        if (!entity.isAlive()) return false;
        if (!(entity instanceof Player)) return true;
        Player pl = (Player)entity;
        if (pl.getAbilities().invulnerable) return false;
        return true;
    }

    public static DamageSource miscDamage(ResourceKey<DamageType> damageType, Level level) {
        return new DamageSource((Holder)level.damageSources().damageTypes.getHolderOrThrow(damageType));
    }

    public static DamageSource miscPositionedDamage(ResourceKey<DamageType> damageType, Level level, Vec3 position) {
        return new DamageSource((Holder)level.damageSources().damageTypes.getHolderOrThrow(damageType), position);
    }

    public static DamageSource entityDamage(ResourceKey<DamageType> damageType, @NotNull Entity attacker) {
        return new DamageSource((Holder)attacker.level().damageSources().damageTypes.getHolderOrThrow(damageType), attacker);
    }

    public static DamageSource positionedEntityDamage(ResourceKey<DamageType> damageType, @Nullable Entity attacker, Vec3 position) {
        return new DamageSource((Holder)RegistryUtil.getDataDrivenRegistry(Registries.DAMAGE_TYPE).getHolderOrThrow(damageType), attacker, attacker, position);
    }

    public static DamageSource indirectEntityDamage(ResourceKey<DamageType> damageType, @Nullable Entity attacker, @Nullable Entity projectile) {
        return new DamageSource((Holder)RegistryUtil.getDataDrivenRegistry(Registries.DAMAGE_TYPE).getHolderOrThrow(damageType), projectile, attacker);
    }

    public static boolean doMobMeleeAttack(Entity attacker, Entity target, float dmg) {
        return DamageUtil.safelyDealDamage(DamageUtil.entityDamage(AoADamageTypes.MOB_MELEE_ATTACK, attacker), target, dmg);
    }

    public static boolean doProjectileAttack(@Nullable Entity attacker, @Nullable Entity projectile, Entity target, float dmg) {
        return DamageUtil.safelyDealDamage(DamageUtil.indirectEntityDamage(AoADamageTypes.RANGED_ATTACK, attacker, projectile), target, dmg);
    }

    public static boolean doVulcaneAttack(@Nullable Entity attacker, Entity target, float dmg) {
        return DamageUtil.safelyDealDamage(DamageUtil.positionedEntityDamage(AoADamageTypes.VULCANE, attacker, target.position()), target, dmg);
    }

    public static boolean doGunAttack(@Nullable Entity attacker, @Nullable Entity projectile, Entity target, Function<DamageSource, Float> damage) {
        DamageSource source = DamageUtil.indirectEntityDamage(AoADamageTypes.GUN, attacker, projectile);
        return DamageUtil.safelyDealDamage(source, target, damage.apply(source).floatValue());
    }

    public static boolean doHeavyGunAttack(@Nullable Entity attacker, @Nullable Entity projectile, Entity target, Function<DamageSource, Float> damage) {
        DamageSource source = DamageUtil.indirectEntityDamage(AoADamageTypes.HEAVY_GUN, attacker, projectile);
        return DamageUtil.safelyDealDamage(source, target, damage.apply(source).floatValue());
    }

    public static boolean doEnergyProjectileAttack(@Nullable Entity attacker, @Nullable Entity projectile, Entity target, float dmg) {
        return DamageUtil.safelyDealDamage(DamageUtil.indirectEntityDamage(AoADamageTypes.ENERGY_PROJECTILE, attacker, projectile), target, dmg);
    }

    public static boolean doMagicProjectileAttack(@Nullable Entity attacker, @Nullable Entity projectile, Entity target, float dmg) {
        return DamageUtil.safelyDealDamage(DamageUtil.indirectEntityDamage(AoADamageTypes.MAGIC_PROJECTILE, attacker, projectile), target, dmg);
    }

    public static boolean doRecoilAttack(Entity target, float dmg) {
        return DamageUtil.safelyDealDamage(DamageUtil.miscDamage(AoADamageTypes.RECOIL, target.level()), target, dmg);
    }

    public static boolean doMiscMagicAttack(Entity attacker, Entity target, float dmg, @Nullable Vec3 position) {
        return DamageUtil.safelyDealDamage(position == null ? DamageUtil.entityDamage(AoADamageTypes.MAGIC_ATTACK, attacker) : DamageUtil.positionedEntityDamage(AoADamageTypes.MAGIC_ATTACK, attacker, position), target, dmg);
    }

    public static boolean doMiscEnergyAttack(Entity attacker, Entity target, float dmg, @Nullable Vec3 position) {
        return DamageUtil.safelyDealDamage(position == null ? DamageUtil.entityDamage(AoADamageTypes.ENERGY_ATTACK, attacker) : DamageUtil.positionedEntityDamage(AoADamageTypes.ENERGY_ATTACK, attacker, position), target, dmg);
    }

    public static void doScaledKnockback(LivingEntity target, LivingEntity attacker, float strength, double xRatio, double yRatio, double zRatio) {
        if (target instanceof Player && !PlayerUtil.shouldPlayerBeAffected((Player)target)) {
            return;
        }
        LivingKnockBackEvent event = CommonHooks.onLivingKnockBack((LivingEntity)target, (float)strength, (double)xRatio, (double)zRatio);
        if (event.isCanceled()) {
            return;
        }
        strength = event.getStrength();
        AttributeInstance knockbackResist = target.getAttribute(Attributes.KNOCKBACK_RESISTANCE);
        AttributeInstance knockbackStrength = attacker.getAttribute(Attributes.ATTACK_KNOCKBACK);
        if (knockbackStrength != null) {
            strength = (float)((double)strength * Math.max(0.0, 1.0 + knockbackStrength.getValue()));
        }
        if (knockbackResist != null) {
            strength = (float)((double)strength * Math.max(0.0, 1.0 - knockbackResist.getValue()));
        }
        Vec3 vec = target.position().subtract(attacker.position());
        if (vec.y == 0.0 && (yRatio != xRatio || yRatio != zRatio)) {
            vec = vec.add(0.0, 1.0, 0.0);
        }
        vec = vec.normalize().multiply(event.getRatioX(), yRatio, event.getRatioZ()).add(attacker.getDeltaMovement().scale(0.5)).multiply((double)strength, (double)strength, (double)strength);
        if (target.onGround() && attacker.getY() == target.getY()) {
            vec = vec.add(0.0, 0.25, 0.0);
        }
        target.setDeltaMovement(vec);
        target.hasImpulse = true;
        target.hurtMarked = true;
    }

    public static void doBodySlamKnockback(LivingEntity target, Entity attacker, float xModifier, float yModifier, float zModifier) {
        double zVelocity;
        double yVelocity;
        if (target instanceof Player && !PlayerUtil.shouldPlayerBeAffected((Player)target)) {
            return;
        }
        Vec3 attackerVelocity = attacker.getDeltaMovement().multiply((double)xModifier, (double)yModifier, (double)zModifier);
        double xVelocity = attackerVelocity.x() * (double)xModifier;
        LivingKnockBackEvent event = CommonHooks.onLivingKnockBack((LivingEntity)target, (float)((float)NumberUtil.average(xVelocity, yVelocity = attackerVelocity.y() * (double)yModifier, zVelocity = attackerVelocity.z() * (double)zModifier)), (double)xVelocity, (double)zVelocity);
        if (event.isCanceled()) {
            return;
        }
        double resist = 1.0;
        AttributeInstance attrib = target.getAttribute(Attributes.KNOCKBACK_RESISTANCE);
        if (attrib != null) {
            resist -= attrib.getValue();
        }
        target.push(event.getRatioX() * resist, yVelocity * resist, event.getRatioZ() * resist);
        target.hurtMarked = true;
    }

    public static void killEntityCleanly(Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            entity.hurt(entity.level().damageSources().genericKill(), Float.MAX_VALUE);
            entity.discard();
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        DamageUtil.safelyDealDamage(livingEntity.level().damageSources().genericKill(), (Entity)livingEntity, livingEntity.getHealth());
        if (livingEntity.getHealth() > 0.0f) {
            livingEntity.setHealth(0.0f);
        }
    }

    public static boolean safelyDealDamage(DamageSource damageSource, Entity target, float dmg) {
        return DamageUtil.safelyDealDamage(damageSource, target, dmg, true);
    }

    public static boolean safelyDealDamage(DamageSource damageSource, Entity target, float dmg, boolean ignoreMiscEntities) {
        if (!(ignoreMiscEntities || target instanceof LivingEntity || target instanceof PartEntity || target instanceof EndCrystal)) {
            return false;
        }
        if (target.hurt(damageSource, dmg)) {
            Entity entity = damageSource.getEntity();
            if (entity instanceof LivingEntity) {
                LivingEntity attacker = (LivingEntity)entity;
                attacker.setLastHurtMob(target);
            }
            return true;
        }
        return false;
    }

    public static boolean isMeleeDamage(DamageSource source) {
        return source.getEntity() != null && source.getDirectEntity() == source.getEntity() && DamageUtil.isPhysicalDamage(source) && !DamageUtil.isEnvironmentalDamage(source);
    }

    public static boolean isEnergyDamage(DamageSource source) {
        return source.is(AoATags.DamageTypes.ENERGY);
    }

    public static boolean isMagicDamage(DamageSource source) {
        return source.is(Tags.DamageTypes.IS_MAGIC) && !DamageUtil.isPoisonDamage(source);
    }

    public static boolean isRangedDamage(DamageSource source) {
        return source.is(DamageTypeTags.IS_PROJECTILE) && !DamageUtil.isMagicDamage(source) && !DamageUtil.isEnergyDamage(source) && !source.is(AoATags.DamageTypes.GUN);
    }

    public static boolean isGunDamage(DamageSource source) {
        return source.is(AoATags.DamageTypes.GUN);
    }

    public static boolean isPoisonDamage(DamageSource source) {
        return source.is(Tags.DamageTypes.IS_POISON);
    }

    public static boolean isPhysicalDamage(DamageSource source) {
        return source.is(Tags.DamageTypes.IS_PHYSICAL);
    }

    public static boolean isVulcaneDamage(DamageSource source) {
        return source.is(AoADamageTypes.VULCANE);
    }

    public static boolean isEnvironmentalDamage(DamageSource source) {
        return source.getEntity() == null && source.is(Tags.DamageTypes.IS_ENVIRONMENT);
    }

    public static boolean isPlayerEnvironmentallyProtected(Player player) {
        Item helmet = player.getItemBySlot(EquipmentSlot.HEAD).getItem();
        if (!(helmet instanceof AdventArmour)) {
            return player.getItemBySlot(EquipmentSlot.HEAD).is(AoATags.Items.AIRTIGHT);
        }
        AdventArmour adventArmour = (AdventArmour)helmet;
        return adventArmour.isHelmetAirTight(player);
    }

    public static float percentDamageReduction(DamageContainer container, float existingReduction, float percentReduction) {
        return existingReduction + (container.getNewDamage() - existingReduction) * percentReduction;
    }
}

