/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.scheduling.async;

import java.util.concurrent.TimeUnit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.tslat.aoa3.content.block.functional.light.LampBlock;
import net.tslat.aoa3.scheduling.AoAScheduler;

public class ShadowlordSpawnTask
implements Runnable {
    private final Player player;
    private final BlockPos altarPosition;
    private boolean spawning = false;
    private boolean spawned = false;

    public ShadowlordSpawnTask(Player player, BlockPos altarPosition) {
        this.player = player;
        this.altarPosition = altarPosition;
    }

    @Override
    public void run() {
        if (this.spawned) {
            for (int x = -2; x <= 2; x += 4) {
                for (int z = -2; z <= 2; z += 4) {
                    BlockPos pos = this.altarPosition.offset(x, 1, z);
                    Block block = this.player.level().getBlockState(pos).getBlock();
                    if (!(block instanceof LampBlock)) continue;
                    this.player.level().setBlockAndUpdate(pos, (BlockState)((BlockState)block.defaultBlockState().setValue((Property)LampBlock.LIT, (Comparable)Boolean.valueOf(true))).setValue((Property)LampBlock.TOGGLEABLE, (Comparable)Boolean.valueOf(false)));
                }
            }
        } else if (this.spawning) {
            this.spawned = true;
            this.schedule(5, TimeUnit.SECONDS);
        } else {
            for (int x = -2; x <= 2; ++x) {
                for (int y = 0; y <= 1; ++y) {
                    for (int z = -2; z <= 2; ++z) {
                        BlockPos pos = this.altarPosition.offset(x, y, z);
                        BlockState state = this.player.level().getBlockState(pos);
                        Block block = state.getBlock();
                        if (!(block instanceof LampBlock) || !((Boolean)state.getValue((Property)LampBlock.LIT)).booleanValue()) continue;
                        this.player.level().setBlock(pos, (BlockState)state.setValue((Property)LampBlock.LIT, (Comparable)Boolean.valueOf(false)), 2);
                        this.schedule(2, TimeUnit.SECONDS);
                        this.player.level().addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 0.0, 0.0, 0.0);
                        return;
                    }
                }
            }
            this.spawning = true;
            this.schedule(1, TimeUnit.SECONDS);
        }
    }

    public void schedule(Integer time, TimeUnit units) {
        AoAScheduler.scheduleAsyncTask(this, time, units);
    }
}

